/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.parameter;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.util.WrappedElement;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.List;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;

public class NucleusRequirePermissionArgument
extends WrappedElement {
    private final String permission;
    private final IPermissionService permissionService;
    private final boolean isOptional;

    public NucleusRequirePermissionArgument(CommandElement wrapped, IPermissionService permissionService, String permission, boolean isOptional) {
        super(wrapped);
        this.permissionService = permissionService;
        this.permission = permission;
        this.isOptional = isOptional;
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        return null;
    }

    public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
        if (!this.permissionService.hasPermission((Subject)source, this.permission)) {
            if (this.isOptional) {
                return;
            }
            Text key = this.getKey();
            throw args.createError(SpongeApiTranslationHelper.t((String)"You do not have permission to use the %s argument", (Object[])new Object[]{key != null ? key : SpongeApiTranslationHelper.t((String)"unknown", (Object[])new Object[0])}));
        }
        this.getWrappedElement().parse(source, args, context);
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        if (!this.permissionService.hasPermission((Subject)src, this.permission)) {
            return ImmutableList.of();
        }
        return this.getWrappedElement().complete(src, args, context);
    }
}

