/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.placeholder.standard;

import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.Optional;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.placeholder.PlaceholderContext;
import org.spongepowered.api.text.placeholder.PlaceholderParser;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

public class OptionPlaceholder
implements PlaceholderParser {
    private final IPermissionService permissionService;

    public OptionPlaceholder(IPermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public Text parse(PlaceholderContext placeholderContext) {
        Optional<Subject> subjectOptional = placeholderContext.getAssociatedObject().filter(x -> x instanceof Subject).map(x -> (Subject)x);
        if (subjectOptional.isPresent() && placeholderContext.getArgumentString().isPresent()) {
            return this.permissionService.getOptionFromSubject(subjectOptional.get(), (String)placeholderContext.getArgumentString().get()).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0)).orElse(Text.EMPTY);
        }
        return Text.EMPTY;
    }

    public String getId() {
        return "nucleus:option";
    }

    public String getName() {
        return "Nucleus Permission Option Placeholder";
    }
}

