/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.warmup;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github.nucleuspowered.nucleus.api.core.NucleusWarmupManagerService;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.WarmupConfig;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IWarmupService;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;

@Singleton
public class WarmupService
implements IWarmupService,
IReloadableService.Reloadable {
    private final Object lockingObject = new Object();
    private final PluginContainer pluginContainer;
    private final IMessageProviderService messageProviderService;
    private WarmupConfig warmupConfig = new WarmupConfig();
    private final BiMap<UUID, UUID> tasks = HashBiMap.create();
    private final BiMap<UUID, NucleusWarmupManagerService.WarmupTask> uuidToWarmup = HashBiMap.create();

    @Inject
    public WarmupService(PluginContainer pluginContainer, IMessageProviderService messageProviderService, IReloadableService reloadableService) {
        this.pluginContainer = pluginContainer;
        this.messageProviderService = messageProviderService;
        reloadableService.registerReloadable(this);
    }

    @Override
    public void executeAfter(Player target, Duration duration, NucleusWarmupManagerService.WarmupTask runnable) {
        this.execute(target, duration, runnable, false, false);
    }

    @Override
    public void executeAfter(Player target, Duration duration, NucleusWarmupManagerService.WarmupTask runnable, boolean sendMessage) {
        this.execute(target, duration, runnable, false, sendMessage);
    }

    @Override
    public void executeAfterAsync(Player target, Duration duration, NucleusWarmupManagerService.WarmupTask runnable) {
        this.execute(target, duration, runnable, true, false);
    }

    @Override
    public void executeAfterAsync(Player target, Duration duration, NucleusWarmupManagerService.WarmupTask runnable, boolean sendMessage) {
        this.execute(target, duration, runnable, true, sendMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Player target, Duration duration, NucleusWarmupManagerService.WarmupTask runnable, boolean async, boolean sendMessage) {
        Object object = this.lockingObject;
        synchronized (object) {
            this.cancelInternal(target);
            if (sendMessage) {
                this.messageProviderService.sendMessageTo((CommandSource)target, "warmup.start", this.messageProviderService.getTimeString(target.getLocale(), duration));
                if (this.warmupConfig.isOnCommand() && this.warmupConfig.isOnMove()) {
                    this.messageProviderService.sendMessageTo((CommandSource)target, "warmup.both");
                } else if (this.warmupConfig.isOnCommand()) {
                    this.messageProviderService.sendMessageTo((CommandSource)target, "warmup.onCommand");
                } else if (this.warmupConfig.isOnMove()) {
                    this.messageProviderService.sendMessageTo((CommandSource)target, "warmup.onMove");
                }
            }
            UUID playerTarget = target.getUniqueId();
            Consumer<Task> taskToSubmit = task -> {
                this.tasks.remove((Object)playerTarget);
                this.uuidToWarmup.remove((Object)task.getUniqueId());
                if (Sponge.getServer().getPlayer(playerTarget).isPresent()) {
                    runnable.run();
                }
            };
            Task.Builder builder = Task.builder().execute(taskToSubmit).delay(duration.toMillis(), TimeUnit.MILLISECONDS).name("Nucleus Warmup task: " + playerTarget.toString());
            if (async) {
                builder.async();
            }
            Task t = builder.submit((Object)this.pluginContainer);
            this.tasks.put((Object)playerTarget, (Object)t.getUniqueId());
            this.uuidToWarmup.put((Object)t.getUniqueId(), (Object)runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(Player player) {
        Object object = this.lockingObject;
        synchronized (object) {
            return this.cancelInternal(player);
        }
    }

    private boolean cancelInternal(Player player) {
        UUID taskUUID = (UUID)this.tasks.get((Object)player.getUniqueId());
        if (taskUUID != null) {
            Sponge.getScheduler().getTaskById(taskUUID).ifPresent(Task::cancel);
            NucleusWarmupManagerService.WarmupTask task = (NucleusWarmupManagerService.WarmupTask)this.uuidToWarmup.get((Object)taskUUID);
            if (task != null) {
                task.onCancel();
            }
            this.uuidToWarmup.remove((Object)taskUUID);
        }
        this.tasks.remove((Object)player.getUniqueId());
        return taskUUID != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitingExecution(Player player) {
        Object object = this.lockingObject;
        synchronized (object) {
            UUID taskUUID = (UUID)this.tasks.get((Object)player.getUniqueId());
            if (taskUUID != null) {
                if (Sponge.getScheduler().getTaskById(taskUUID).isPresent()) {
                    return true;
                }
                this.uuidToWarmup.remove((Object)taskUUID);
            }
            this.tasks.remove((Object)player.getUniqueId());
            return false;
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.warmupConfig = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class).getWarmupConfig();
    }
}

