/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.util;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ClassUtil {
    public static <S> List<Class<? extends S>> getSuperclassChain(Class<? extends S> clazz, Class<S> superclass) {
        Set<List<Class<S>>> superclassChains = ClassUtil.getSuperclassChainsInternal(clazz, superclass, true);
        return superclassChains.isEmpty() ? null : superclassChains.iterator().next();
    }

    public static <S> Set<List<Class<? extends S>>> getSuperclassChains(Class<? extends S> clazz, Class<S> superclass) {
        return ClassUtil.getSuperclassChainsInternal(clazz, superclass, false);
    }

    private static <S> Set<List<Class<? extends S>>> getSuperclassChainsInternal(Class<? extends S> clazz, Class<S> superclass, boolean oneChainSufficient) {
        Preconditions.checkNotNull(clazz, (Object)"'clazz' and 'superclass' may not be non-null");
        Preconditions.checkNotNull(superclass, (Object)"'clazz' and 'superclass' may not be non-null");
        if (!superclass.isAssignableFrom(clazz)) {
            return Collections.emptySet();
        }
        return ClassUtil.getSuperclassSubchains(clazz, superclass, oneChainSufficient, superclass.isInterface());
    }

    private static <S> Set<List<Class<? extends S>>> getSuperclassSubchains(Class<? extends S> subclass, Class<S> superclass, boolean oneChainSufficient, boolean considerInterfaces) {
        if (subclass.equals(superclass)) {
            LinkedList<Class<S>> subchain = new LinkedList<Class<S>>();
            subchain.add(subclass);
            return Collections.singleton(subchain);
        }
        HashSet supertypes = new HashSet();
        Class<S> immediateSuperclass = subclass.getSuperclass();
        if (immediateSuperclass != null) {
            supertypes.add(immediateSuperclass);
        }
        if (considerInterfaces) {
            supertypes.addAll(Arrays.asList(subclass.getInterfaces()));
        }
        HashSet subchains = new HashSet();
        for (Class clazz : supertypes) {
            Set<List<Class<S>>> subchainsFromSupertype = ClassUtil.getSuperclassSubchains(clazz, superclass, oneChainSufficient, considerInterfaces);
            if (subchainsFromSupertype.isEmpty()) continue;
            if (oneChainSufficient) {
                ClassUtil.addSubchain(subchains, subclass, subchainsFromSupertype.iterator().next());
                return subchains;
            }
            for (List list : subchainsFromSupertype) {
                ClassUtil.addSubchain(subchains, subclass, list);
            }
        }
        return subchains;
    }

    private static <T> void addSubchain(Set<List<Class<? extends T>>> subchains, Class<? extends T> clazz, List<Class<? extends T>> subchainFromSupertype) {
        subchainFromSupertype.add(0, clazz);
        subchains.add(subchainFromSupertype);
    }

    public static boolean isAnyAssignableFrom(Collection<Class<?>> superclasses, Class<?> clazz) {
        Preconditions.checkNotNull(superclasses, (Object)"All arguments must be non-null");
        Preconditions.checkNotNull(clazz, (Object)"All arguments must be non-null");
        for (Class<?> superclass : superclasses) {
            if (!superclass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstance(Collection<Class<?>> superclasses, Object instance) {
        Preconditions.checkNotNull(superclasses, (Object)"Superclasses non-null");
        for (Class<?> superclass : superclasses) {
            if (!superclass.isInstance(instance)) continue;
            return true;
        }
        return false;
    }

    public static List<Field> getAllDeclaredFields(Class<?> clazz) {
        return ClassUtil.getAllDeclaredFields(clazz, Object.class);
    }

    public static <T> List<Field> getAllDeclaredFields(Class<T> clazz, Class<? super T> superclass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<T> immediateSuperclass : ClassUtil.getSuperclassChain(clazz, superclass)) {
            fields.addAll(Arrays.asList(immediateSuperclass.getDeclaredFields()));
        }
        return fields;
    }

    public static List<Field> getAllAnnotatedDeclaredFields(Class<?> clazz, Class<? extends Annotation> annotationType) {
        Preconditions.checkNotNull(clazz, (Object)"All arguments must be non-null");
        Preconditions.checkNotNull(annotationType, (Object)"All arguments must be non-null");
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : ClassUtil.getAllDeclaredFields(clazz)) {
            if (!field.isAnnotationPresent(annotationType)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static Set<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationType) {
        Preconditions.checkNotNull(clazz, (Object)"'clazz' must be non-null");
        if (annotationType == null) {
            return new HashSet<Method>();
        }
        HashSet<Method> annotatedMethods = new HashSet<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(annotationType)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    @Nonnull
    public static <S> List<Class<?>> getActualTypeArguments(Class<? extends S> typedClass, Class<S> typedSuperclass) {
        Preconditions.checkNotNull(typedSuperclass, (Object)"All arguments must be non-null");
        Preconditions.checkNotNull(typedClass, (Object)"All arguments must be non-null");
        if (!typedSuperclass.isAssignableFrom(typedClass)) {
            return null;
        }
        TypeVariable<Class<S>>[] typedClassTypeParams = typedSuperclass.getTypeParameters();
        if (typedClassTypeParams.length == 0) {
            return new ArrayList(0);
        }
        HashMap typeAssignments = new HashMap(typedClassTypeParams.length);
        List<Class<S>> superclassChain = ClassUtil.getSuperclassChain(typedClass, typedSuperclass);
        assert (superclassChain != null) : Arrays.asList(typedSuperclass, typedClass);
        for (int i = 0; i < superclassChain.size() - 1; ++i) {
            ClassUtil.collectAssignments(superclassChain.get(i), superclassChain.get(i + 1), typeAssignments);
        }
        return ClassUtil.getActualAssignments(typedClassTypeParams, typeAssignments);
    }

    private static void collectAssignments(Class<?> clazz, Class<?> supertype, Map<TypeVariable<?>, Class<?>> typeAssignments) {
        TypeVariable<Class<?>>[] typeParameters = supertype.getTypeParameters();
        if (typeParameters.length == 0) {
            return;
        }
        Type[] actualTypeAttributes = ClassUtil.getActualTypeAttributes(clazz, supertype);
        assert (typeParameters.length == actualTypeAttributes.length) : Arrays.asList(typeParameters, typeAssignments);
        for (int i = 0; i < actualTypeAttributes.length; ++i) {
            Type type = actualTypeAttributes[i];
            if (type instanceof Class) {
                typeAssignments.put(typeParameters[i], (Class)type);
                continue;
            }
            if (type instanceof ParameterizedType) {
                assert (((ParameterizedType)type).getRawType() instanceof Class) : type;
                typeAssignments.put(typeParameters[i], (Class)((ParameterizedType)type).getRawType());
                continue;
            }
            assert (type instanceof TypeVariable) : type;
            if (!typeAssignments.containsKey(type)) continue;
            typeAssignments.put(typeParameters[i], typeAssignments.get(type));
        }
    }

    private static Type[] getActualTypeAttributes(Class<?> clazz, Class<?> supertype) {
        Type genericSupertype = ClassUtil.tryGetGenericSupertype(clazz, supertype);
        return genericSupertype instanceof ParameterizedType ? ((ParameterizedType)genericSupertype).getActualTypeArguments() : supertype.getTypeParameters();
    }

    private static Type tryGetGenericSupertype(Class<?> clazz, Class<?> supertype) {
        Type[] genericInterfaces;
        if (!supertype.isInterface()) {
            return clazz.getGenericSuperclass();
        }
        for (Type interfaceType : genericInterfaces = clazz.getGenericInterfaces()) {
            if (interfaceType instanceof ParameterizedType && ((ParameterizedType)interfaceType).getRawType().equals(supertype)) {
                return interfaceType;
            }
            assert (interfaceType instanceof Class) : interfaceType;
            if (!interfaceType.equals(supertype)) continue;
            return interfaceType;
        }
        throw new AssertionError((Object)("Unable to find generic superclass information for class '" + clazz + "' and superclass/-interface '" + supertype + "'"));
    }

    private static List<Class<?>> getActualAssignments(TypeVariable<?>[] typedClassTypeParams, Map<TypeVariable<?>, Class<?>> typeAssignments) {
        int numTypedClassTypeParams = typedClassTypeParams.length;
        ArrayList actualAssignments = new ArrayList(numTypedClassTypeParams);
        for (TypeVariable<?> typedClassTypeParam : typedClassTypeParams) {
            actualAssignments.add(typeAssignments.get(typedClassTypeParam));
        }
        return actualAssignments;
    }
}

