/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.storage.dataobjects.keyed;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.storage.dataobjects.keyed.DataKeyImpl;
import io.github.nucleuspowered.storage.dataobjects.keyed.IKeyedDataObject;
import io.github.nucleuspowered.storage.dataobjects.keyed.ListDataKey;
import io.github.nucleuspowered.storage.dataobjects.keyed.MappedDataKey;
import io.github.nucleuspowered.storage.dataobjects.keyed.MappedListDataKey;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public interface DataKey<R, O extends IKeyedDataObject<?>> {
    public static <T, O extends IKeyedDataObject<?>> DataKey<T, O> of(TypeToken<T> type, Class<O> target, String ... key) {
        return new DataKeyImpl<Object, O>(key, type, target, null);
    }

    public static <T, O extends IKeyedDataObject<?>> DataKey<T, O> of(T def, TypeToken<T> type, Class<O> target, String ... key) {
        return new DataKeyImpl<T, O>(key, type, target, def);
    }

    public static <T, O extends IKeyedDataObject<?>> ListKey<T, O> ofList(TypeToken<T> type, Class<O> target, String ... key) {
        return new ListDataKey<T, O>(key, type, target);
    }

    public static <K, V, O extends IKeyedDataObject<?>> MapKey<K, V, O> ofMap(TypeToken<K> keyType, TypeToken<V> value, Class<O> target, String ... key) {
        return new MappedDataKey<K, V, O>(key, keyType, value, target);
    }

    public static <K, V, O extends IKeyedDataObject<?>> MapListKey<K, V, O> ofMapList(TypeToken<K> keyType, TypeToken<V> listValueType, Class<O> target, String ... key) {
        return new MappedListDataKey<K, V, O>(key, keyType, listValueType, target);
    }

    public Class<O> target();

    public String[] getKey();

    public TypeToken<R> getType();

    @Nullable
    public R getDefault();

    public static interface MapListKey<K, V, O extends IKeyedDataObject<?>>
    extends DataKey<Map<K, List<V>>, O> {
    }

    public static interface MapKey<K, V, O extends IKeyedDataObject<?>>
    extends DataKey<Map<K, V>, O> {
    }

    public static interface ListKey<R, O extends IKeyedDataObject<?>>
    extends DataKey<List<R>, O> {
    }
}

