/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.capability.provider;

import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CapabilityBrokerDirectional
implements ICapabilityProvider {
    private final Map<EnumFacing, Map<Capability<?>, Object>> capabilities = new EnumMap(EnumFacing.class);
    private final Map<Capability<?>, Object> nonDirectionalCapabilities = new IdentityHashMap();

    public <T> CapabilityBrokerDirectional with(@Nullable EnumFacing dir, Capability<T> capability, T aspect) {
        if (dir == null) {
            return this.with(capability, aspect);
        }
        this.capabilities.computeIfAbsent(dir, k -> new IdentityHashMap()).put(capability, aspect);
        return this;
    }

    public <T> CapabilityBrokerDirectional with(Capability<T> capability, T aspect) {
        this.nonDirectionalCapabilities.put(capability, aspect);
        return this;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        Map<Capability<?>, Object> dirCaps;
        if (facing != null && (dirCaps = this.capabilities.get(facing)) != null && dirCaps.containsKey(capability)) {
            return true;
        }
        return this.nonDirectionalCapabilities.containsKey(capability);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Object impl;
        Map<Capability<?>, Object> dirCaps;
        if (facing != null && (dirCaps = this.capabilities.get(facing)) != null && (impl = dirCaps.get(capability)) != null) {
            return (T)impl;
        }
        return (T)this.nonDirectionalCapabilities.get(capability);
    }
}

