/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.math;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class LinAlUtils {
    public static final Vec3d X_POS = new Vec3d(1.0, 0.0, 0.0);
    public static final Vec3d X_NEG = new Vec3d(-1.0, 0.0, 0.0);
    public static final Vec3d Y_POS = new Vec3d(0.0, 1.0, 0.0);
    public static final Vec3d Y_NEG = new Vec3d(0.0, -1.0, 0.0);
    public static final Vec3d Z_POS = new Vec3d(0.0, 0.0, 1.0);
    public static final Vec3d Z_NEG = new Vec3d(0.0, 0.0, -1.0);
    private static final EnumMap<EnumFacing, Vec3d> FACE_VEC_MAPPING = Arrays.stream(EnumFacing.field_82609_l).collect(Collectors.toMap(d -> d, d -> new Vec3d(d.func_176730_m()), (a, b) -> b, () -> new EnumMap(EnumFacing.class)));

    public static Vec3d findOrthogonal(Vec3d vec) {
        if (vec.field_72450_a == 0.0) {
            return X_POS;
        }
        if (vec.field_72448_b == 0.0) {
            return Y_POS;
        }
        if (vec.field_72449_c == 0.0) {
            return Z_POS;
        }
        return new Vec3d(vec.field_72450_a, -vec.field_72448_b, (vec.field_72448_b * vec.field_72448_b - vec.field_72450_a * vec.field_72450_a) / vec.field_72449_c);
    }

    public static Vec3d rotate(Vec3d vec, Vec3d axis, float angle) {
        double cos = MathHelper.func_76134_b((float)angle);
        double uncos = 1.0 - cos;
        double sin = MathHelper.func_76126_a((float)angle);
        double dot = vec.func_72430_b(axis);
        Vec3d cross = vec.func_72431_c(axis);
        return new Vec3d(cos * vec.field_72450_a + sin * cross.field_72450_a + uncos * dot * axis.field_72450_a, cos * vec.field_72448_b + sin * cross.field_72448_b + uncos * dot * axis.field_72448_b, cos * vec.field_72449_c + sin * cross.field_72449_c + uncos * dot * axis.field_72449_c);
    }

    public static Vec3d project(Vec3d from, Vec3d onto) {
        Vec3d normBasis = onto.func_72432_b();
        return normBasis.func_186678_a(from.func_72430_b(normBasis));
    }

    public static Vec3d reflect2D(Vec3d target, Vec3d symmetry) {
        return LinAlUtils.project(target, symmetry).func_186678_a(2.0).func_178788_d(target);
    }

    @Nullable
    public static Vec3d castOntoPlane(Vec3d origin, Vec3d dir, Vec3d planarPoint, Vec3d planeNormal) {
        double a = planeNormal.func_72430_b(dir);
        if (a == 0.0) {
            return null;
        }
        double scale = planeNormal.func_72430_b(planarPoint.func_178788_d(origin)) / a;
        return scale > 0.0 ? origin.func_178787_e(dir.func_186678_a(scale)) : null;
    }

    public static boolean intersectsLine(AxisAlignedBB prism, Vec3d lineMin, Vec3d lineMax) {
        double x1 = lineMin.field_72450_a;
        double x2 = lineMax.field_72450_a;
        double dx = x2 - x1;
        double y1 = lineMin.field_72448_b;
        double y2 = lineMax.field_72448_b;
        double dy = y2 - y1;
        double z1 = lineMin.field_72449_c;
        double z2 = lineMax.field_72449_c;
        double dz = z2 - z1;
        double dydx = dy / dx;
        double dzdx = dz / dx;
        double dzdy = dz / dy;
        double inter1 = (prism.field_72340_a - x1) * dydx + y1;
        double inter2 = (prism.field_72336_d - x1) * dydx + y1;
        if (Math.min(inter1, inter2) > prism.field_72337_e || Math.max(inter1, inter2) < prism.field_72338_b) {
            return false;
        }
        inter1 = (prism.field_72340_a - x1) * dzdx + z1;
        inter2 = (prism.field_72336_d - x1) * dzdx + z1;
        if (Math.min(inter1, inter2) > prism.field_72334_f || Math.max(inter1, inter2) < prism.field_72339_c) {
            return false;
        }
        inter1 = (prism.field_72338_b - y1) * dzdy + z1;
        inter2 = (prism.field_72337_e - y1) * dzdy + z1;
        return !(Math.min(inter1, inter2) > prism.field_72334_f) && !(Math.max(inter1, inter2) < prism.field_72339_c);
    }

    public static Vec3d getDir(EnumFacing dir) {
        return FACE_VEC_MAPPING.get(dir);
    }
}

