/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.GlobalRegion;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.world.World;

public class RegionGlobalForExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (args.hasAny("dimension")) {
            String dimension = (String)args.getOne("dimension").get();
            if (RegionUtils.load(dimension) != null) {
                MessageUtils.sendErrorMessage(src, RegionText.REGION_DIMENSION_EXISTS.getValue());
            } else {
                Optional optionalWorld = Sponge.getServer().getWorld(dimension);
                if (optionalWorld.isPresent()) {
                    World dimWorld = (World)optionalWorld.get();
                    GlobalRegion dimRegion = new GlobalRegion(dimWorld.getName(), false);
                    if (RegionUtils.save(dimRegion)) {
                        MessageUtils.sendSuccessMessage(src, RegionText.REGION_SAVED.getValue());
                    } else {
                        MessageUtils.sendErrorMessage(src, RegionText.REGION_SAVE_EXCEPTION.getValue());
                    }
                } else {
                    MessageUtils.sendErrorMessage(src, RegionText.DIMENSION_NOT_FOUND.getValue());
                }
            }
        } else {
            MessageUtils.sendErrorMessage(src, this.getCommandUsage());
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg globalfor <dimension-id>";
    }
}

