/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.command;

import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.components.RegionLocation;
import com.universeguard.region.enums.RegionPoint;
import com.universeguard.region.enums.RegionText;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;

public class RegionSetExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (args.hasAny("point") && args.hasAny("x") && args.hasAny("y") && args.hasAny("z")) {
            RegionPoint point = RegionPoint.valueOf(((String)args.getOne("point").get()).toUpperCase());
            int x = (Integer)args.getOne("x").get();
            int y = (Integer)args.getOne("y").get();
            int z = (Integer)args.getOne("z").get();
            Region region = null;
            if (RegionUtils.hasPendingRegion(src)) {
                region = RegionUtils.getPendingRegion(src);
                if (region.isGlobal()) {
                    MessageUtils.sendErrorMessage(src, RegionText.REGION_LOCAL_ONLY.getValue());
                    return CommandResult.empty();
                }
            } else {
                region = new LocalRegion("");
            }
            if (region != null) {
                String world;
                LocalRegion localRegion = (LocalRegion)region;
                RegionLocation regionPoint = null;
                String dimension = "minecraft:overworld";
                String string = world = localRegion.getWorld() != null ? localRegion.getWorld().getName() : Sponge.getServer().getDefaultWorldName();
                if (localRegion.getFirstPoint() != null) {
                    dimension = localRegion.getFirstPoint().getDimension();
                } else if (localRegion.getSecondPoint() != null) {
                    dimension = localRegion.getSecondPoint().getDimension();
                }
                regionPoint = new RegionLocation(x, y, z, dimension, world);
                if (regionPoint != null) {
                    switch (point) {
                        case PRIMARY: {
                            localRegion.setFirstPoint(regionPoint);
                            MessageUtils.sendSuccessMessage(src, RegionText.FIRST_POINT_SET.getValue() + " " + x + " " + y + " " + z);
                            break;
                        }
                        case SECONDARY: {
                            localRegion.setSecondPoint(regionPoint);
                            MessageUtils.sendSuccessMessage(src, RegionText.SECOND_POINT_SET.getValue() + " " + x + " " + y + " " + z);
                        }
                    }
                }
                RegionUtils.updatePendingRegion(src, (Region)localRegion);
                if (src instanceof Player) {
                    RegionUtils.setRegionScoreboard((Player)src, localRegion);
                }
            }
        } else {
            MessageUtils.sendErrorMessage(src, this.getCommandUsage());
        }
        return CommandResult.empty();
    }

    private String getCommandUsage() {
        return "/rg set <point> <x> <y> <z>";
    }
}

