/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.IMachine;
import ic2.api.energy.tile.IHeatSource;
import ic2.api.recipe.IFermenterRecipeManager;
import ic2.api.recipe.Recipes;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IOutputMachine;
import ic2.core.util.obj.ITankListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.Nullable;
import trinsdar.ic2c_extras.Ic2cExtrasConfig;
import trinsdar.ic2c_extras.container.ContainerFermenter;
import trinsdar.ic2c_extras.util.StackHelper;

public class TileEntityFermenter
extends TileEntityMachine
implements IOutputMachine,
ITickable,
IFluidHandler,
IHasGui,
ITankListener {
    int heat;
    @NetworkField(index=3)
    IC2Tank inputTank = new IC2Tank(10000){

        public boolean canFillFluidType(FluidStack fluid) {
            return super.canFillFluidType(fluid) && fluid.getFluid().getName().equals("biomass");
        }
    };
    @NetworkField(index=4)
    IC2Tank outputTank = new IC2Tank(2000);
    @NetworkField(index=5)
    int fertProgress = 0;
    @NetworkField(index=6)
    int bioProgress = 0;
    @NetworkField(index=7)
    int maxBioProgress = 4000;
    @NetworkField(index=8)
    int maxFertProgres = Ic2cExtrasConfig.biomassPerFertilizer;
    int storedHeat = 0;
    Map.Entry<String, IFermenterRecipeManager.FermentationProperty> lastRecipe = null;
    boolean shouldCheckRecipe = true;
    boolean checkHeatSource = true;
    private static int outputSlot = 0;
    private static int inputTankInSlot = 1;
    private static int inputTankOutSlot = 2;
    private static int outputTankInSlot = 3;
    private static int outputTankOutSlot = 4;

    public TileEntityFermenter() {
        super(7);
        this.addNetworkFields(new String[]{"inputTank", "outputTank", "fertProgress", "bioProgress", "maxBioProgress", "maxFertProgress"});
        this.addGuiFields(new String[]{"inputTank", "outputTank", "fertProgress", "bioProgress", "maxBioProgress", "maxFertProgress"});
        this.inputTank.addListener((ITankListener)this);
        this.outputTank.addListener((ITankListener)this);
    }

    protected void addSlots(InventoryHandler handler) {
        ContainerFermenter.FluidItemFilter filter = new ContainerFermenter.FluidItemFilter();
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, new int[]{inputTankInSlot, outputTankInSlot});
        handler.registerDefaultSlotAccess(AccessRule.Export, new int[]{outputSlot, inputTankOutSlot, outputTankOutSlot});
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), new int[]{outputSlot, inputTankOutSlot, outputTankOutSlot});
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), new int[]{inputTankInSlot, outputTankInSlot});
        handler.registerInputFilter((IFilter)filter, new int[]{inputTankInSlot, outputTankInSlot});
        handler.registerSlotType(SlotType.Input, new int[]{inputTankInSlot, outputTankInSlot});
        handler.registerSlotType(SlotType.Output, new int[]{outputSlot, inputTankOutSlot, outputTankOutSlot});
    }

    public IC2Tank getInputTank() {
        return this.inputTank;
    }

    public IC2Tank getOutputTank() {
        return this.outputTank;
    }

    public int getBioProgress() {
        return this.bioProgress;
    }

    public int getFertProgress() {
        return this.fertProgress;
    }

    public int getMaxBioProgress() {
        return this.maxBioProgress;
    }

    public int getMaxFertProgres() {
        return this.maxFertProgres;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IHasInventory getOutputInventory() {
        return new RangedInventoryWrapper((IHasInventory)this, new int[]{outputSlot, outputTankOutSlot, inputTankOutSlot});
    }

    public IHasInventory getInputInventory() {
        return null;
    }

    public double getEnergy() {
        return 0.0;
    }

    public boolean useEnergy(double v, boolean b) {
        return false;
    }

    public void setRedstoneSensitive(boolean b) {
    }

    public boolean isRedstoneSensitive() {
        return false;
    }

    public boolean isProcessing() {
        return this.getActive();
    }

    public boolean isValidInput(ItemStack itemStack) {
        return false;
    }

    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        return Collections.singleton(IMachineUpgradeItem.UpgradeType.ImportExport);
    }

    public World getMachineWorld() {
        return this.func_145831_w();
    }

    public BlockPos getMachinePos() {
        return this.func_174877_v();
    }

    public void func_73660_a() {
        if (this.fertProgress >= this.maxFertProgres) {
            if (this.getStackInSlot(outputSlot).func_190926_b()) {
                this.setStackInSlot(outputSlot, Ic2Items.fertilizer.func_77946_l());
                this.fertProgress = 0;
                this.getNetwork().updateTileGuiField((TileEntity)this, "fertProgress");
            } else if (this.getStackInSlot(outputSlot).func_190916_E() < 64) {
                this.getStackInSlot(outputSlot).func_190917_f(1);
                this.fertProgress = 0;
                this.getNetwork().updateTileGuiField((TileEntity)this, "fertProgress");
            }
            this.doUpgradeStuff();
            this.shouldCheckRecipe = true;
        }
        if (this.shouldCheckRecipe) {
            this.lastRecipe = this.getRecipe();
            this.shouldCheckRecipe = false;
        }
        if (this.storedHeat < 0) {
            this.storedHeat = 0;
        }
        StackHelper.doFluidContainerThings(this, this.inputTank, inputTankInSlot, inputTankOutSlot);
        StackHelper.doFluidContainerThings(this, this.outputTank, outputTankInSlot, outputTankOutSlot);
        TileEntity offset = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.getFacing()));
        if (this.lastRecipe != null && offset instanceof IHeatSource && this.getStackInSlot(outputSlot).func_190916_E() < 64) {
            IHeatSource heatSource = (IHeatSource)offset;
            int simHeatReceived = heatSource.drawHeat(this.getFacing().func_176734_d(), 100, false);
            if (simHeatReceived > 0 || this.storedHeat > 0) {
                this.storedHeat += simHeatReceived;
                if (this.bioProgress < this.maxBioProgress) {
                    int room = this.maxBioProgress - this.bioProgress;
                    int progress = Math.min(room, this.storedHeat);
                    this.bioProgress += progress;
                    this.storedHeat -= progress;
                    this.getNetwork().updateTileGuiField((TileEntity)this, "bioProgress");
                } else {
                    this.bioProgress = 0;
                    this.inputTank.drain(this.lastRecipe.getValue().inputAmount, true);
                    this.outputTank.fill(FluidRegistry.getFluidStack((String)this.lastRecipe.getValue().output, (int)this.lastRecipe.getValue().outputAmount), true);
                    this.shouldCheckRecipe = true;
                    if (this.lastRecipe.getKey().equals("biomass")) {
                        this.fertProgress += this.maxFertProgres / Ic2cExtrasConfig.biomassProcessesPerFertilizer;
                        this.getNetwork().updateTileGuiField((TileEntity)this, "fertProgress");
                    }
                    this.getNetwork().updateTileGuiField((TileEntity)this, "bioProgress");
                    this.doUpgradeStuff();
                }
                if (!this.isActive) {
                    this.setActive(true);
                }
            } else {
                if (this.isActive) {
                    this.setActive(false);
                }
                this.doUpgradeStuff();
            }
        } else {
            if (this.isActive) {
                this.setActive(false);
            }
            this.doUpgradeStuff();
        }
    }

    private Map.Entry<String, IFermenterRecipeManager.FermentationProperty> getRecipe() {
        FluidStack input = this.inputTank.getFluid();
        if (input == null) {
            return null;
        }
        String fluidName = input.getFluid().getName();
        IFermenterRecipeManager.FermentationProperty property = Recipes.fermenter.getFermentationInformation(input.getFluid());
        if (property == null) {
            return null;
        }
        if (!(this.lastRecipe == null || this.lastRecipe.getKey().equals(fluidName) && input.amount >= property.inputAmount)) {
            this.lastRecipe = null;
            this.maxBioProgress = 4000;
            this.bioProgress = 0;
            this.getNetwork().updateTileGuiField((TileEntity)this, "maxBioProgress");
            this.getNetwork().updateTileGuiField((TileEntity)this, "bioProgress");
        }
        if (this.lastRecipe == null && Recipes.fermenter.acceptsFluid(input.getFluid()) && input.amount >= property.inputAmount) {
            this.lastRecipe = new AbstractMap.SimpleEntry<String, IFermenterRecipeManager.FermentationProperty>(fluidName, (IFermenterRecipeManager.FermentationProperty)Recipes.fermenter.getRecipeMap().get(fluidName));
            this.maxBioProgress = this.lastRecipe.getValue().heat;
            this.getNetwork().updateTileGuiField((TileEntity)this, "maxBioProgress");
        }
        if (this.lastRecipe == null) {
            return null;
        }
        this.maxBioProgress = this.lastRecipe.getValue().heat;
        this.getNetwork().updateTileGuiField((TileEntity)this, "maxBioProgress");
        FluidStack output = this.outputTank.getFluid();
        if (output == null) {
            return this.lastRecipe;
        }
        if (output.isFluidEqual(Recipes.fermenter.getOutput(input.getFluid())) && this.outputTank.getFluidAmount() + property.outputAmount <= this.outputTank.getCapacity()) {
            return this.lastRecipe;
        }
        return null;
    }

    private void doUpgradeStuff() {
        for (int i = 0; i < 2; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 2);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            ((IMachineUpgradeItem)item.func_77973_b()).onTick(item, (IMachine)this);
        }
    }

    public void onBlockUpdate(Block block) {
        super.onBlockUpdate(block);
        this.checkHeatSource = true;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        this.shouldCheckRecipe = true;
    }

    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.inputTank.writeToNBT(this.getTag(nbt, "inputTank"));
        this.outputTank.writeToNBT(this.getTag(nbt, "outputTank"));
        nbt.func_74768_a("bioProgress", this.bioProgress);
        nbt.func_74768_a("fertProgress", this.fertProgress);
        nbt.func_74768_a("storedHeat", this.storedHeat);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTank.readFromNBT(nbt.func_74775_l("inputTank"));
        this.outputTank.readFromNBT(nbt.func_74775_l("outputTank"));
        this.bioProgress = nbt.func_74762_e("bioProgress");
        this.fertProgress = nbt.func_74762_e("fertProgress");
        this.storedHeat = nbt.func_74762_e("storedHeat");
    }

    public void onLoaded() {
        super.onLoaded();
        this.shouldCheckRecipe = true;
    }

    public IFluidTankProperties[] getTankProperties() {
        ArrayList<IFluidTankProperties> list = new ArrayList<IFluidTankProperties>();
        list.addAll(Arrays.asList(this.inputTank.getTankProperties()));
        list.addAll(Arrays.asList(this.outputTank.getTankProperties()));
        return list.toArray(new IFluidTankProperties[0]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.inputTank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.outputTank.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.outputTank.drain(maxDrain, doDrain);
    }

    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerFermenter(entityPlayer.field_71071_by, this);
    }

    public Class<? extends GuiScreen> getGuiClass(EntityPlayer entityPlayer) {
        return GuiComponentContainer.class;
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return !this.func_145837_r();
    }

    public boolean hasGui(EntityPlayer entityPlayer) {
        return true;
    }

    public void onTankChanged(IFluidTank iFluidTank) {
        this.getNetwork().updateTileGuiField((TileEntity)this, "inputTank");
        this.getNetwork().updateTileGuiField((TileEntity)this, "outputTank");
        this.shouldCheckRecipe = true;
    }

    public static void init() {
        Recipes.fermenter.addRecipe("biomass", 20, 4000, "biogas", 400);
    }
}

