/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.guicomponent;

import ic2.core.fluid.LayeredFluidTank;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.base.FluidTankComp;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiComponentTank
extends FluidTankComp {
    IFluidTank tank;
    Vec2i pos;

    public GuiComponentTank(Box2D box, IFluidTank fluid, Vec2i vec, Box2D secBox) {
        super(box, fluid, vec, secBox);
        this.pos = vec;
        this.tank = fluid;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        Box2D box = this.getPosition();
        if (this.tank instanceof LayeredFluidTank) {
            gui.displayMultiGaugge(gui.getXOffset(), gui.getYOffset(), this.pos.getX(), this.pos.getY(), box.getX(), box.getY(), gui.getTextureObject(), (LayeredFluidTank)this.tank);
        } else {
            this.displayGauge(gui, gui.getXOffset(), gui.getYOffset(), this.pos.getX(), this.pos.getY(), box.getX(), box.getY(), gui.getTextureObject(), this.tank.getFluid());
        }
    }

    public void displayGauge(GuiIC2 gui, int guiX, int guiY, int u, int v, int x, int y, ITextureObject texture, FluidStack liquid) {
        int w = this.getPosition().getLenght();
        int h = this.getPosition().getHeight();
        if (liquid != null) {
            TextureMap map = gui.field_146297_k.func_147117_R();
            TextureAtlasSprite liquidIcon = null;
            Fluid fluid = liquid.getFluid();
            if (fluid != null && fluid.getStill() != null) {
                liquidIcon = map.func_110572_b(fluid.getStill().toString());
            }
            gui.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            int color = fluid.getColor(liquid);
            float scale = (float)Math.min(liquid.amount, this.tank.getCapacity()) / (float)this.tank.getCapacity();
            GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color >> 0 & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
            for (int col = 0; col < w / 16; ++col) {
                for (int row = 0; row <= h / 16; ++row) {
                    gui.func_175175_a(guiX + x + col * 16, guiY + y + row * 16 - 1, liquidIcon, 16, 16);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179144_i((int)texture.func_110552_b());
            int mask = (int)Math.floor((float)h * scale);
            if (mask == 0 && liquid.amount > 0) {
                mask = 1;
            }
            gui.func_73729_b(guiX + x, guiY + y - 1, x, y - 1, w, h - mask + 1);
            gui.func_73729_b(guiX + x, guiY + y, u, v, w, h);
        }
    }
}

