/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.gui.tinker.frame;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.machinemuse.numina.client.gui.scrollable.ScrollableFrame;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.client.sound.Musique;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.numina.math.geometry.MusePoint2D;
import net.machinemuse.numina.math.geometry.MuseRect;
import net.machinemuse.numina.math.geometry.MuseRelativeRect;
import net.machinemuse.numina.module.IPowerModule;
import net.machinemuse.powersuits.client.sound.SoundDictionary;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableItem;
import net.machinemuse.powersuits.gui.tinker.clickable.ClickableModule;
import net.machinemuse.powersuits.gui.tinker.frame.ItemSelectionFrame;
import net.machinemuse.powersuits.gui.tinker.frame.ModuleSelectionSubFrame;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import org.lwjgl.opengl.GL11;

public class ModuleSelectionFrame
extends ScrollableFrame {
    protected ItemSelectionFrame target;
    protected Map<String, ModuleSelectionSubFrame> categories = new LinkedHashMap<String, ModuleSelectionSubFrame>();
    protected List<ClickableModule> moduleButtons = new LinkedList<ClickableModule>();
    protected int selectedModule = -1;
    protected IPowerModule prevSelection;
    protected ClickableItem lastItem;
    protected MuseRect lastPosition;

    public ModuleSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame target) {
        super(topleft, bottomright, borderColour, insideColour);
        this.target = target;
    }

    public void update(double mousex, double mousey) {
        super.update(mousex, mousey);
    }

    public void draw() {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.refreshButtonPositions();
        }
        if (this.target.getSelectedItem() != null) {
            if (this.lastItem != this.target.getSelectedItem()) {
                this.loadModules();
            }
            this.totalsize = 0;
            for (ModuleSelectionSubFrame frame : this.categories.values()) {
                this.totalsize = (int)Math.max(frame.border.bottom() - this.border.top(), (double)this.totalsize);
            }
            this.currentscrollpixels = Math.min(this.currentscrollpixels, this.getMaxScrollPixels());
            super.preDraw();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)(-this.currentscrollpixels), (float)0.0f);
            this.drawItems();
            this.drawSelection();
            GL11.glPopMatrix();
            super.postDraw();
        }
    }

    private void drawItems() {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.drawPartial((int)((double)this.currentscrollpixels + this.border.top() + 4.0), (int)((double)this.currentscrollpixels + this.border.top() + this.border.height() - 4.0));
        }
    }

    private void drawSelection() {
        MusePoint2D pos;
        ClickableModule module = this.getSelectedModule();
        if (module != null && (pos = this.moduleButtons.get(this.selectedModule).getPosition()).getY() > (double)this.currentscrollpixels + this.border.top() + 4.0 && pos.getY() < (double)this.currentscrollpixels + this.border.top() + this.border.height() - 4.0) {
            MuseRenderer.drawCircleAround((double)pos.getX(), (double)pos.getY(), (double)10.0);
        }
    }

    public ClickableModule getSelectedModule() {
        if (this.moduleButtons.size() > this.selectedModule && this.selectedModule != -1) {
            return this.moduleButtons.get(this.selectedModule);
        }
        return null;
    }

    public void loadModules() {
        this.lastPosition = null;
        ClickableItem selectedItem = this.target.getSelectedItem();
        if (selectedItem != null) {
            this.moduleButtons = new LinkedList<ClickableModule>();
            this.categories = new LinkedHashMap<String, ModuleSelectionSubFrame>();
            List workingModules = ModuleManager.INSTANCE.getValidModulesForItem(selectedItem.getItem());
            Iterator it = workingModules.iterator();
            while (it.hasNext()) {
                IPowerModule module = (IPowerModule)it.next();
                if (module.isAllowed() || ModuleManager.INSTANCE.itemHasModule(selectedItem.getItem(), module.getDataName())) continue;
                it.remove();
            }
            if (workingModules.size() > 0) {
                this.selectedModule = -1;
                for (IPowerModule module : workingModules) {
                    ModuleSelectionSubFrame frame = this.getOrCreateCategory(module.getCategory().getName());
                    ClickableModule moduleClickable = frame.addModule(module);
                    if (!module.isAllowed()) {
                        moduleClickable.setAllowed(false);
                    } else if (ModuleManager.INSTANCE.itemHasModule(selectedItem.getItem(), module.getDataName())) {
                        moduleClickable.setInstalled(true);
                    }
                    if (moduleClickable.getModule().equals(this.prevSelection)) {
                        this.selectedModule = this.moduleButtons.size();
                    }
                    this.moduleButtons.add(moduleClickable);
                }
            }
            for (ModuleSelectionSubFrame frame : this.categories.values()) {
                frame.refreshButtonPositions();
            }
        }
    }

    private ModuleSelectionSubFrame getOrCreateCategory(String category) {
        if (this.categories.containsKey(category)) {
            return this.categories.get(category);
        }
        MuseRelativeRect position = new MuseRelativeRect(this.border.left() + 4.0, this.border.top() + 4.0, this.border.right() - 4.0, this.border.top() + 32.0);
        position.setBelow(this.lastPosition);
        this.lastPosition = position;
        ModuleSelectionSubFrame frame = new ModuleSelectionSubFrame(category, position);
        this.categories.put(category, frame);
        return frame;
    }

    public void onMouseDown(double x, double y, int button) {
        super.onMouseDown(x, y, button);
        if (this.border.left() < x && this.border.right() > x && this.border.top() < y && this.border.bottom() > y) {
            y += (double)this.currentscrollpixels;
            int i = 0;
            for (ClickableModule module : this.moduleButtons) {
                if (module.hitBox(x, y)) {
                    Musique.playClientSound((SoundEvent)SoundDictionary.SOUND_EVENT_GUI_SELECT, (SoundCategory)SoundCategory.BLOCKS, (float)1.0f, null);
                    this.selectedModule = i;
                    this.prevSelection = module.getModule();
                    break;
                }
                ++i;
            }
        }
    }

    public List<String> getToolTip(int x, int y) {
        if (this.border.left() < (double)x && this.border.right() > (double)x && this.border.top() < (double)y && this.border.bottom() > (double)y) {
            y += this.currentscrollpixels;
            if (this.moduleButtons != null) {
                int moduleHover = -1;
                int i = 0;
                for (ClickableModule module : this.moduleButtons) {
                    if (module.hitBox(x, y)) {
                        moduleHover = i;
                        break;
                    }
                    ++i;
                }
                if (moduleHover > -1) {
                    return this.moduleButtons.get(moduleHover).getToolTip();
                }
                return null;
            }
        }
        return null;
    }
}

