/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.parser;

import com.google.common.collect.ImmutableMap;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.parser.DelegateParser;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.parser.ValueParser;
import java.util.function.Predicate;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;

public class PredicateParser<T>
extends DelegateParser<T, T> {
    private final Predicate<T> predicate;

    public PredicateParser(Predicate<T> predicate, ValueParser<T> delegate, ImmutableMap<String, String> messages) {
        super(delegate, messages);
        this.predicate = predicate;
    }

    @Override
    public T parseValue(CommandSource src, CommandArgs args) throws ArgumentParseException {
        Object value = this.delegate.parseValue(src, args);
        try {
            if (this.predicate.test(value)) {
                return value;
            }
        }
        catch (Exception e) {
            throw args.createError(this.getMessage("exception", "<exception>", "exception", e.getMessage()));
        }
        throw args.createError(this.getMessage("invalid-value", "The value <value> does not meet the requirements for this argument.", "value", value));
    }
}

