/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdcontrol.teslalibs.message;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.message.Message;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Locale;
import java.util.ResourceBundle;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;

public class MessageService {
    private final LoadingCache<Locale, ResourceBundle> cache = Caffeine.newBuilder().build(k -> ResourceBundle.getBundle(name, k, loader));

    private MessageService(ClassLoader loader, String name) {
    }

    public static MessageService of(ClassLoader loader, String name) {
        return new MessageService(loader, name);
    }

    public static MessageService of(Path path, String name) throws MalformedURLException {
        return MessageService.of(new URLClassLoader(new URL[]{path.toUri().toURL()}), name);
    }

    public static MessageService of(PluginContainer container, String name) {
        return MessageService.of(new URLClassLoader(new URL[]{Sponge.class.getClassLoader().getResource("assets/" + container.getId())}), name);
    }

    public ResourceBundle getBundle(Locale locale) {
        return (ResourceBundle)this.cache.get((Object)locale);
    }

    public Message get(String key, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        return Message.of(bundle.containsKey(key) ? bundle.getString(key) : key);
    }

    public void reload() {
        this.cache.invalidateAll();
    }
}

