/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory;

import mekanism.common.base.ISustainedInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;

public class InventoryPersonalChest
extends InventoryBasic {
    private final ItemStack itemStack;
    private boolean reading;
    public EnumHand currentHand = EnumHand.MAIN_HAND;

    public InventoryPersonalChest(ItemStack stack, EnumHand hand) {
        super("PersonalChest", false, 55);
        this.itemStack = stack;
        this.currentHand = hand;
        this.read();
    }

    public InventoryPersonalChest(ItemStack stack) {
        super("PersonalChest", false, 55);
        this.itemStack = stack;
        this.read();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.reading) {
            this.write();
        }
    }

    public void func_174889_b(EntityPlayer player) {
        this.read();
    }

    public void func_174886_c(EntityPlayer player) {
        this.write();
    }

    public void write() {
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < this.func_70302_i_(); ++slotCount) {
            if (this.func_70301_a(slotCount).func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            this.func_70301_a(slotCount).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        if (!this.getStack().func_190926_b()) {
            ((ISustainedInventory)this.getStack().func_77973_b()).setInventory(tagList, this.getStack());
        }
    }

    public void read() {
        if (this.reading) {
            return;
        }
        this.reading = true;
        NBTTagList tagList = ((ISustainedInventory)this.getStack().func_77973_b()).getInventory(this.getStack());
        if (tagList != null) {
            for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
                NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
                byte slotID = tagCompound.func_74771_c("Slot");
                if (slotID < 0 || slotID >= this.func_70302_i_()) continue;
                this.func_70299_a(slotID, new ItemStack(tagCompound));
            }
        }
        this.reading = false;
    }

    public ItemStack getStack() {
        return this.itemStack;
    }
}

