/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorLV;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGasGenerator
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.IDirectionalTile,
ITickable,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
EnergyHelper.IIEInternalFluxConnector,
IEBlockInterfaces.ITileDrop,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.ISoundTile {
    public boolean active;
    public EnumFacing facing = EnumFacing.NORTH;
    public FluidTank tank = new FluidTank(8000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && FuelHandler.isValidFuel(fluid.getFluid());
        }
    };
    int lastTank = 0;
    boolean inICNet = false;
    private long lastTransfer = -1L;
    public int currentTickAccepted = 0;
    private FluxStorage energyStorage = new FluxStorage(this.getMaxStorage(), this.getMaxInput(), 0);
    boolean firstTick = true;
    EnergyHelper.IEForgeEnergyWrapper energyWrapper;

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.active = nbt.func_74767_n("active");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.energyStorage.readFromNBT(nbt);
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("active", this.active);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
        this.energyStorage.writeToNBT(nbt);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return facing == EnumFacing.UP;
        }
        return super.hasCapability(capability, facing);
    }

    public void func_73660_a() {
        Fluid fuel;
        if (!this.field_145850_b.field_72995_K && this.lastTank != this.tank.getFluidAmount()) {
            this.markContainingBlockForUpdate(null);
            this.lastTank = this.tank.getFluidAmount();
        }
        this.active = false;
        if (!this.field_145850_b.func_175640_z(this.field_174879_c) && this.tank.getFluid() != null && FuelHandler.isValidFuel(fuel = this.tank.getFluid().getFluid())) {
            int amount = FuelHandler.getFuelUsedPerTick(fuel);
            if (this.tank.getFluidAmount() >= amount) {
                TileEntity te;
                BlockPos outputPos;
                if (!this.field_145850_b.field_72995_K) {
                    outputPos = this.func_174877_v().func_177972_a(this.facing);
                    te = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)outputPos);
                    if (this.energyStorage.receiveEnergy(FuelHandler.getFluxGeneratedPerTick(fuel), false) > 0) {
                        this.tank.drain(new FluidStack(fuel, amount), true);
                    }
                } else {
                    outputPos = this.func_174877_v().func_177972_a(this.facing);
                    te = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)outputPos);
                    if (this.energyStorage.receiveEnergy(FuelHandler.getFluxGeneratedPerTick(fuel), true) > 0) {
                        this.active = true;
                    }
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            int temp;
            if (this.energyStorage.getEnergyStored() > 0 && (temp = this.transferEnergy(this.energyStorage.getEnergyStored(), true, 0)) > 0) {
                this.energyStorage.modifyEnergyStored(-this.transferEnergy(temp, false, 0));
                this.func_70296_d();
            }
            this.currentTickAccepted = 0;
        } else if (this.firstTick) {
            Set conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, this.field_174879_c);
            if (conns != null) {
                for (ImmersiveNetHandler.Connection conn : conns) {
                    if (this.field_174879_c.compareTo((Vec3i)conn.end) >= 0 || !this.field_145850_b.func_175667_e(conn.end)) continue;
                    this.markContainingBlockForUpdate(null);
                }
            }
            this.firstTick = false;
        }
        if (this.field_145850_b.field_72995_K) {
            ImmersiveEngineering.proxy.handleTileSound(IESounds.dieselGenerator, (TileEntity)this, this.active, 0.3f, 0.5f);
            if (this.active && this.field_145850_b.func_82737_E() % 4L == 0L) {
                BlockPos exhaust = this.field_174879_c;
                EnumFacing fl = this.facing;
                EnumFacing fw = this.facing.func_176746_e();
                this.field_145850_b.func_175688_a(this.field_145850_b.field_73012_v.nextInt(10) == 0 ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL, (double)exhaust.func_177958_n() + 0.5 + (double)((float)(fl.func_82601_c() * 2) / 16.0f) + (double)((float)(-fw.func_82601_c()) * 0.6125f), (double)exhaust.func_177956_o() + 0.4, (double)exhaust.func_177952_p() + 0.5 + (double)((float)(fl.func_82599_e() * 2) / 16.0f) + (double)((float)(-fw.func_82599_e()) * 0.6125f), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)heldItem);
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank)) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (player.func_70093_af()) {
            boolean added = false;
            if (player.field_71071_by.func_70448_g().func_190926_b()) {
                added = true;
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.getTileDrop(player, this.field_145850_b.func_180495_p(this.field_174879_c)));
            } else {
                added = player.field_71071_by.func_70441_a(this.getTileDrop(player, this.field_145850_b.func_180495_p(this.field_174879_c)));
            }
            if (added) {
                this.field_145850_b.func_175698_g(this.field_174879_c);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.IEConfig.increasedTileRenderdistance;
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND))) {
            String s = null;
            s = this.tank.getFluid() != null ? this.tank.getFluid().getLocalizedName() + ": " + this.tank.getFluidAmount() + "mB" : I18n.func_135052_a((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return null;
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    public void readTank(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (!toItem || write) {
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readTank(stack.func_77978_p());
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"energyStorage")) {
                this.energyStorage.setEnergy(ItemNBTHelper.getInt((ItemStack)stack, (String)"energyStorage"));
            }
        }
    }

    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagCompound tag = new NBTTagCompound();
        this.writeTank(tag, true);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        if (this.energyStorage.getEnergyStored() > 0) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"energyStorage", (int)this.energyStorage.getEnergyStored());
        }
        return stack;
    }

    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        float xo = (float)this.facing.func_176730_m().func_177958_n() * 0.6f + 0.5f;
        float zo = (float)this.facing.func_176730_m().func_177952_p() * 0.6f + 0.5f;
        return new Vec3d((double)xo, 0.5, (double)zo);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        float xo = (float)this.facing.func_176730_m().func_177958_n() * 0.5f + 0.5f;
        float zo = (float)this.facing.func_176730_m().func_177952_p() * 0.5f + 0.5f;
        return new Vec3d((double)xo, 0.5, (double)zo);
    }

    public boolean isEnergyOutput() {
        return false;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    protected boolean canTakeLV() {
        return true;
    }

    protected boolean canTakeMV() {
        return true;
    }

    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (facing != this.facing || this.isRelay()) {
            return null;
        }
        if (this.energyWrapper == null || this.energyWrapper.side != this.facing) {
            this.energyWrapper = new EnergyHelper.IEForgeEnergyWrapper((EnergyHelper.IIEInternalFluxConnector)this, this.facing);
        }
        return this.energyWrapper;
    }

    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return IEEnums.SideConfig.OUTPUT;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return false;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    private int getMaxStorage() {
        return Config.IEConfig.Machines.capacitorLV_storage;
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxStorage();
    }

    public int extractEnergy(EnumFacing from, int energy, boolean simulate) {
        return 0;
    }

    public int transferEnergy(int energy, boolean simulate, int energyType) {
        int received = 0;
        if (!this.field_145850_b.field_72995_K) {
            IImmersiveConnectable end;
            int powerLeft;
            Set outputs = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC((Object)((Object)this)), this.field_145850_b);
            int powerForSort = powerLeft = Math.min(Math.min(this.getMaxOutput(), this.getMaxInput()), energy);
            if (outputs.size() < 1) {
                return 0;
            }
            int sum = 0;
            HashMap<ImmersiveNetHandler.AbstractConnection, Integer> powerSorting = new HashMap<ImmersiveNetHandler.AbstractConnection, Integer>();
            for (ImmersiveNetHandler.AbstractConnection con : outputs) {
                int atmOut;
                int tempR;
                end = ApiUtils.toIIC((Object)con.end, (World)this.field_145850_b);
                if (con.cableType == null || end == null || (tempR = end.outputEnergy(atmOut = Math.min(powerForSort, con.cableType.getTransferRate()), true, energyType)) <= 0) continue;
                powerSorting.put(con, tempR);
                sum += tempR;
            }
            if (sum > 0) {
                for (ImmersiveNetHandler.AbstractConnection con : powerSorting.keySet()) {
                    int tempR;
                    end = ApiUtils.toIIC((Object)con.end, (World)this.field_145850_b);
                    if (con.cableType == null || end == null) continue;
                    float prio = (float)((Integer)powerSorting.get(con)).intValue() / (float)sum;
                    int output = (int)((float)powerForSort * prio);
                    int r = tempR = end.outputEnergy(Math.min(output, con.cableType.getTransferRate()), true, energyType);
                    int maxInput = this.getMaxInput();
                    tempR -= (int)Math.max(0.0, Math.floor((float)tempR * con.getPreciseLossRate(tempR, maxInput)));
                    end.outputEnergy(tempR, simulate, energyType);
                    HashSet<IImmersiveConnectable> passedConnectors = new HashSet<IImmersiveConnectable>();
                    float intermediaryLoss = 0.0f;
                    for (ImmersiveNetHandler.Connection sub : con.subConnections) {
                        float length = (float)sub.length / (float)sub.cableType.getMaxLength();
                        float baseLoss = (float)sub.cableType.getLossRatio();
                        float mod = (float)(maxInput - tempR) / (float)maxInput / 0.25f * 0.1f;
                        intermediaryLoss = MathHelper.func_76131_a((float)(intermediaryLoss + length * (baseLoss + baseLoss * mod)), (float)0.0f, (float)1.0f);
                        int transferredPerCon = ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).containsKey(sub) ? (Integer)ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).get(sub) : 0;
                        transferredPerCon += r;
                        if (simulate) continue;
                        ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).put(sub, transferredPerCon);
                        IImmersiveConnectable subStart = ApiUtils.toIIC((Object)sub.start, (World)this.field_145850_b);
                        IImmersiveConnectable subEnd = ApiUtils.toIIC((Object)sub.end, (World)this.field_145850_b);
                        if (subStart != null && passedConnectors.add(subStart)) {
                            subStart.onEnergyPassthrough((int)((float)r - (float)r * intermediaryLoss));
                        }
                        if (subEnd == null || !passedConnectors.add(subEnd)) continue;
                        subEnd.onEnergyPassthrough((int)((float)r - (float)r * intermediaryLoss));
                    }
                    received += r;
                    if ((powerLeft -= r) > 0) continue;
                    break;
                }
            }
        }
        return received;
    }

    public int getMaxInput() {
        return TileEntityConnectorLV.connectorInputValues[1];
    }

    public int getMaxOutput() {
        return TileEntityConnectorLV.connectorInputValues[1];
    }

    public boolean shoudlPlaySound(String sound) {
        return this.active;
    }
}

