/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime.objects;

import com.mcsimonflash.sponge.activetime.ActiveTime;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.api.asset.Asset;

public class ConfigHolder {
    private HoconConfigurationLoader loader;
    private CommentedConfigurationNode node;

    public ConfigHolder(Path path, boolean asset) throws IOException {
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                if (asset) {
                    ((Asset)ActiveTime.getContainer().getAsset(path.getFileName().toString()).get()).copyToFile(path);
                } else {
                    Files.createFile(path, new FileAttribute[0]);
                }
            }
            this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
            this.node = (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException e) {
            ActiveTime.getLogger().error("Error loading config file! File:[" + path.getFileName().toString() + "]");
            throw e;
        }
    }

    public CommentedConfigurationNode getNode(Object ... path) {
        return this.node.getNode(path);
    }

    public boolean save() {
        try {
            this.loader.save((ConfigurationNode)this.node);
            return true;
        }
        catch (IOException e) {
            ActiveTime.getLogger().error("Unable to save config file! Error:");
            e.printStackTrace();
            return false;
        }
    }
}

