/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime.objects;

import com.google.common.collect.ImmutableList;
import com.mcsimonflash.sponge.activetime.managers.Storage;
import com.mcsimonflash.sponge.activetime.managers.Util;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;

public class Milestone {
    private final String name;
    private final int activetime;
    private final boolean repeatable;
    private final ImmutableList<String> commands;

    public Milestone(String name, int activetime, boolean repeatable, ImmutableList<String> commands) {
        this.name = name;
        this.activetime = activetime;
        this.repeatable = repeatable;
        this.commands = commands;
    }

    public void process(Player player, int time) {
        int last = Storage.getMilestoneTime(player.getUniqueId(), this);
        if (this.repeatable ? time >= this.activetime + last : last == 0 && time >= this.activetime) {
            Storage.setMilestoneTime(player.getUniqueId(), this, time);
            List modifiedCommands = this.commands.stream().map(s -> s.replace("<player>", player.getName()).replace("<activetime>", Util.printTime(time))).collect(Collectors.toList());
            Util.createTask("ActiveTime GiveMilestone Sync Processor (" + player.getName() + ")", task -> modifiedCommands.forEach(c -> Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), c)), 0, false);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getActiveTime() {
        return this.activetime;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public ImmutableList<String> getCommands() {
        return this.commands;
    }
}

