/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.recipe;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.subtile.SubTileEntity;

public class RecipePureDaisy {
    public static final int DEFAULT_TIME = 150;
    private final Object input;
    private final IBlockState outputState;
    private final int time;

    public RecipePureDaisy(Object input, IBlockState state) {
        this(input, state, 150);
    }

    public RecipePureDaisy(Object input, IBlockState state, int time) {
        Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
        this.input = input;
        this.outputState = state;
        this.time = time;
        if (!(input == null || input instanceof String || input instanceof Block || input instanceof IBlockState)) {
            throw new IllegalArgumentException("input must be an oredict String, Block, or IBlockState");
        }
    }

    public boolean matches(World world, BlockPos pos, SubTileEntity pureDaisy, IBlockState state) {
        if (this.input instanceof Block) {
            return state.func_177230_c() == this.input;
        }
        if (this.input instanceof IBlockState) {
            return state == this.input;
        }
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
        String oredict = (String)this.input;
        return this.isOreDict(stack, oredict);
    }

    private boolean isOreDict(ItemStack stack, String entry) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ItemStack ostack : OreDictionary.getOres((String)entry, (boolean)false)) {
            if (!OreDictionary.itemMatches((ItemStack)ostack, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean set(World world, BlockPos pos, SubTileEntity pureDaisy) {
        if (!world.field_72995_K) {
            world.func_175656_a(pos, this.outputState);
        }
        return true;
    }

    public Object getInput() {
        return this.input;
    }

    public IBlockState getOutputState() {
        return this.outputState;
    }

    public int getTime() {
        return this.time;
    }
}

