/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import landmaster.plustic.tools.ToolLaserGun;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.tools.ranged.ProjectileCore;
import slimeknights.tconstruct.library.traits.AbstractProjectileTrait;

public class Jaded
extends AbstractProjectileTrait {
    public static final Jaded jaded = new Jaded();
    public static final String JADED_LEVEL_TAG = "PlusTiC_JadedLevel";
    public static final String JADED_TIMER_TAG = "PlusTiC_JadedTimer";
    public static final String JADED_LASTHEALTH_TAG = "PlusTiC_JadedLastHealth";

    public Jaded() {
        super("jaded", 59010);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected void applyJaded(Entity target) {
        if (!target.field_70170_p.field_72995_K) {
            IEntityMultiPart parent;
            EntityLivingBase targetLiving = null;
            if (target instanceof EntityLivingBase) {
                targetLiving = (EntityLivingBase)target;
            }
            if (target instanceof MultiPartEntityPart && (parent = ((MultiPartEntityPart)target).field_70259_a) instanceof EntityLivingBase) {
                targetLiving = (EntityLivingBase)((MultiPartEntityPart)target).field_70259_a;
            }
            if (targetLiving == null) {
                return;
            }
            NBTTagCompound nbt = targetLiving.getEntityData();
            nbt.func_74774_a(JADED_LEVEL_TAG, (byte)Math.min(nbt.func_74771_c(JADED_LEVEL_TAG) + 1, 3));
            nbt.func_74768_a(JADED_TIMER_TAG, 80);
            nbt.func_74776_a(JADED_LASTHEALTH_TAG, targetLiving.func_110143_aJ());
        }
    }

    public void afterHit(EntityProjectileBase projectile, World world, ItemStack ammoStack, EntityLivingBase attacker, Entity target, double impactSpeed) {
        this.applyJaded(target);
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getSource() instanceof EntityDamageSource && !(event.getSource() instanceof EntityDamageSourceIndirect) && !(event.getSource() instanceof ProjectileCore.DamageSourceProjectileForEndermen) && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            ItemStack stack;
            ItemStack itemStack = stack = event.getSource() instanceof ToolLaserGun.LaserDamageSource ? ((ToolLaserGun.LaserDamageSource)event.getSource()).getStack() : ((EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca();
            if (this.isToolWithTrait(stack)) {
                this.applyJaded(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        NBTTagCompound nbt = event.getEntity().getEntityData();
        if (!event.getEntity().field_70170_p.field_72995_K && nbt.func_74762_e(JADED_TIMER_TAG) > 0) {
            if (event.getEntityLiving().func_110143_aJ() > nbt.func_74760_g(JADED_LASTHEALTH_TAG)) {
                float healthDiff = event.getEntityLiving().func_110143_aJ() - nbt.func_74760_g(JADED_LASTHEALTH_TAG);
                float scalar = (float)(3 - nbt.func_74771_c(JADED_LEVEL_TAG)) / 3.0f;
                event.getEntityLiving().func_70606_j(nbt.func_74760_g(JADED_LASTHEALTH_TAG) + healthDiff * scalar);
            }
            nbt.func_74776_a(JADED_LASTHEALTH_TAG, event.getEntityLiving().func_110143_aJ());
            nbt.func_74768_a(JADED_TIMER_TAG, Math.max(nbt.func_74762_e(JADED_TIMER_TAG) - 1, 0));
            if (nbt.func_74762_e(JADED_TIMER_TAG) <= 0) {
                nbt.func_82580_o(JADED_LEVEL_TAG);
                nbt.func_82580_o(JADED_TIMER_TAG);
                nbt.func_82580_o(JADED_LASTHEALTH_TAG);
            }
        }
    }
}

