/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.renderer;

import java.util.List;
import javax.vecmath.Matrix4f;
import net.malisis.blocks.MalisisBlocksSettings;
import net.malisis.blocks.block.MixedBlock;
import net.malisis.blocks.item.MixedBlockBlockItem;
import net.malisis.blocks.tileentity.MixedBlockTileEntity;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.MergedVertex;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.icon.Icon;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;

public class MixedBlockRenderer
extends MalisisRenderer<MixedBlockTileEntity> {
    private IBlockState mixedBlockState;
    private Shape shape;
    private Shape simpleShape;
    private Shape[][] shapes;
    private RenderParameters rp;
    private IBlockState state1;
    private IBlockState state2;

    protected void initialize() {
        this.simpleShape = new Cube();
        this.shapes = new Shape[][]{new Shape[6], new Shape[6]};
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            Cube s0 = new Cube();
            Cube s1 = new Cube();
            s0.enableMergedVertexes();
            s1.enableMergedVertexes();
            this.shapes[0][dir.ordinal()] = s0.removeFace(s0.getFace(Face.nameFromDirection((EnumFacing)dir))).storeState();
            this.shapes[1][dir.ordinal()] = s1.shrink(dir, 0.999f).removeFace(s1.getFace(Face.nameFromDirection((EnumFacing)dir))).storeState();
        }
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set((Object)false);
        this.rp.usePerVertexAlpha.set((Object)true);
        this.rp.useWorldSensitiveIcon.set((Object)false);
    }

    private boolean setup() {
        if (this.renderType == RenderType.ITEM) {
            if (!this.itemStack.func_77942_o()) {
                return false;
            }
            Pair<IBlockState, IBlockState> pair = MixedBlockBlockItem.readNBT(this.itemStack.func_77978_p());
            this.state1 = (IBlockState)pair.getLeft();
            this.state2 = (IBlockState)pair.getRight();
            this.mixedBlockState = ((MixedBlock)this.block).func_176223_P().func_177226_a((IProperty)DirectionalComponent.ALL, (Comparable)EnumFacing.SOUTH);
        } else if (this.renderType == RenderType.BLOCK) {
            this.tileEntity = this.tileEntity;
            if (this.tileEntity == null) {
                return false;
            }
            this.state1 = ((MixedBlockTileEntity)this.tileEntity).getState1();
            this.state2 = ((MixedBlockTileEntity)this.tileEntity).getState2();
            this.mixedBlockState = this.blockState;
        }
        return this.state1 != null && this.state2 != null;
    }

    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType tranformType) {
        return DefaultRenderer.block.getTransform(item, tranformType);
    }

    public void render() {
        if (!this.setup()) {
            return;
        }
        if (this.renderType == RenderType.ITEM) {
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179142_g();
            GlStateManager.func_179103_j((int)7425);
            this.enableBlending();
        }
        if (((Boolean)MalisisBlocksSettings.simpleMixedBlockRendering.get()).booleanValue() || !Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            this.renderSimple();
            return;
        }
        this.set(this.state1);
        this.drawPass(true);
        this.set(this.state2);
        this.drawPass(false);
    }

    private void setColor() {
        this.rp.colorMultiplier.set((Object)(this.block instanceof BlockGrass ? 0xFFFFFF : MixedBlockRenderer.colorMultiplier((IBlockAccess)this.world, (BlockPos)this.pos, (IBlockState)this.blockState)));
    }

    private void renderSimple() {
        boolean reversed = false;
        float width = 1.0f;
        float height = 1.0f;
        float depth = 1.0f;
        float offsetX = 0.0f;
        float offestY = 0.0f;
        float offsetZ = 0.0f;
        EnumFacing dir = DirectionalComponent.getDirection((IBlockState)this.mixedBlockState);
        if (dir == EnumFacing.DOWN || dir == EnumFacing.UP) {
            height = 0.5f;
            offestY = 0.5f;
            if (dir == EnumFacing.UP) {
                reversed = true;
            }
        }
        if (dir == EnumFacing.WEST || dir == EnumFacing.EAST) {
            width = 0.5f;
            offsetX = 0.5f;
            if (dir == EnumFacing.EAST) {
                reversed = true;
            }
        }
        if (dir == EnumFacing.NORTH || dir == EnumFacing.SOUTH) {
            depth = 0.5f;
            offsetZ = 0.5f;
            if (dir == EnumFacing.SOUTH) {
                reversed = true;
            }
        }
        this.shape = this.simpleShape;
        this.set(reversed ? this.state2 : this.state1);
        this.shape.resetState().setSize(width, height, depth);
        this.rp.icon.set((Object)Icon.from((IBlockState)this.blockState));
        this.setColor();
        this.drawShape(this.shape, this.rp);
        this.set(reversed ? this.state1 : this.state2);
        this.shape.resetState().setSize(width, height, depth).translate(offsetX, offestY, offsetZ);
        this.rp.icon.set((Object)Icon.from((IBlockState)this.blockState));
        this.setColor();
        this.drawShape(this.shape, this.rp);
    }

    private void drawPass(boolean firstBlock) {
        EnumFacing dir = DirectionalComponent.getDirection((IBlockState)this.mixedBlockState);
        if (firstBlock) {
            dir = dir.func_176734_d();
        }
        this.shape = this.shapes[firstBlock && this.renderType == RenderType.BLOCK ? 1 : 0][dir.ordinal()];
        this.shape.resetState();
        if (this.shouldShadeFace(firstBlock)) {
            List vertexes = this.shape.getMergedVertexes(dir);
            for (MergedVertex v : vertexes) {
                v.setAlpha(0);
            }
        }
        this.rp.icon.set((Object)Icon.from((IBlockState)this.blockState));
        this.setColor();
        this.drawShape(this.shape, this.rp);
    }

    protected boolean shouldShadeFace(Boolean firstBlock) {
        IBlockState other;
        if (this.block.canRenderInLayer(this.blockState, BlockRenderLayer.TRANSLUCENT) || this.block.canRenderInLayer(this.blockState, BlockRenderLayer.CUTOUT) || this.block.canRenderInLayer(this.blockState, BlockRenderLayer.CUTOUT_MIPPED)) {
            return true;
        }
        IBlockState iBlockState = other = firstBlock != false ? this.state2 : this.state1;
        if (other.func_177230_c().canRenderInLayer(this.blockState, BlockRenderLayer.TRANSLUCENT) || other.func_177230_c().canRenderInLayer(this.blockState, BlockRenderLayer.CUTOUT) || other.func_177230_c().canRenderInLayer(this.blockState, BlockRenderLayer.CUTOUT_MIPPED)) {
            return true;
        }
        return firstBlock == false;
    }

    protected boolean shouldRenderFace(Face face, RenderParameters params) {
        if (this.renderType != RenderType.BLOCK || this.world == null || this.block == null) {
            return true;
        }
        if (params != null && ((Boolean)params.renderAllFaces.get()).booleanValue()) {
            return true;
        }
        RenderParameters p = face.getParameters();
        if (p.direction.get() == null) {
            return true;
        }
        return this.mixedBlockState.func_185894_c(this.world, this.pos, (EnumFacing)p.direction.get());
    }
}

