/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.PatternReplacementResult;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.util.IntFunction2;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class TextReplacementRenderer
implements ComponentRenderer<State> {
    static final TextReplacementRenderer INSTANCE = new TextReplacementRenderer();

    private TextReplacementRenderer() {
    }

    @Override
    public @NonNull Component render(@NonNull Component component, @NonNull State state) {
        if (!state.running) {
            return component;
        }
        List children = null;
        Component modified = component;
        if (component instanceof TextComponent) {
            String content = ((TextComponent)component).content();
            Matcher matcher = state.pattern.matcher(content);
            int replacedUntil = 0;
            while (matcher.find()) {
                PatternReplacementResult result;
                if ((result = state.continuer.apply(++state.matchCount, state.replaceCount)) == PatternReplacementResult.CONTINUE) continue;
                if (result == PatternReplacementResult.STOP) {
                    state.running = false;
                    break;
                }
                if (matcher.start() == 0) {
                    if (matcher.end() == content.length()) {
                        ComponentLike replacement = state.replacement.apply(matcher, (TextComponent.Builder)Component.text().content(matcher.group()).style(component.style()));
                        modified = replacement == null ? Component.empty() : replacement.asComponent();
                    } else {
                        modified = Component.text("", component.style());
                        ComponentLike child = state.replacement.apply(matcher, Component.text().content(matcher.group()));
                        if (child != null) {
                            children = TextReplacementRenderer.listOrNew(children, component.children().size() + 1);
                            children.add(child.asComponent());
                        }
                    }
                } else {
                    children = TextReplacementRenderer.listOrNew(children, component.children().size() + 2);
                    if (state.replaceCount == 0) {
                        modified = ((TextComponent)component).content(content.substring(0, matcher.start()));
                    } else if (replacedUntil < matcher.start()) {
                        children.add(Component.text(content.substring(replacedUntil, matcher.start())));
                    }
                    ComponentLike builder = state.replacement.apply(matcher, Component.text().content(matcher.group()));
                    if (builder != null) {
                        children.add(builder.asComponent());
                    }
                }
                ++state.replaceCount;
                replacedUntil = matcher.end();
            }
            if (replacedUntil < content.length() && replacedUntil > 0) {
                children = TextReplacementRenderer.listOrNew(children, component.children().size());
                children.add(Component.text(content.substring(replacedUntil)));
            }
        } else if (modified instanceof TranslatableComponent) {
            List<Component> args = ((TranslatableComponent)modified).args();
            ArrayList<Component> newArgs = null;
            for (int i = 0; i < args.size(); ++i) {
                Component original = args.get(i);
                Component replaced = this.render(original, state);
                if (replaced != component && newArgs == null) {
                    newArgs = new ArrayList<Component>(args.size());
                    if (i > 0) {
                        newArgs.addAll(args.subList(0, i));
                    }
                }
                if (newArgs == null) continue;
                newArgs.add(replaced);
            }
            if (newArgs != null) {
                modified = ((TranslatableComponent)modified).args(newArgs);
            }
        }
        if (state.running) {
            HoverEvent<?> rendered;
            HoverEvent<?> event = modified.style().hoverEvent();
            if (event != null && event != (rendered = event.withRenderedValue(this, state))) {
                modified = modified.style(s -> s.hoverEvent(rendered));
            }
            List<Component> oldChildren = component.children();
            boolean first = true;
            int size = oldChildren.size();
            for (int i = 0; i < size; ++i) {
                Component child = oldChildren.get(i);
                Component replaced = this.render(child, state);
                if (replaced != child) {
                    children = TextReplacementRenderer.listOrNew(children, size);
                    if (first) {
                        children.addAll(oldChildren.subList(0, i));
                    }
                    first = false;
                }
                if (children == null) continue;
                children.add(replaced);
            }
        } else if (children != null) {
            children.addAll(component.children());
        }
        if (children != null) {
            return modified.children(children);
        }
        return modified;
    }

    private static <T> @NonNull List<T> listOrNew(@Nullable List<T> init, int size) {
        return init == null ? new ArrayList(size) : init;
    }

    static final class State {
        final Pattern pattern;
        final BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement;
        final IntFunction2<PatternReplacementResult> continuer;
        boolean running = true;
        int matchCount = 0;
        int replaceCount = 0;

        State(@NonNull Pattern pattern, @NonNull BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement, @NonNull IntFunction2<PatternReplacementResult> continuer) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.continuer = continuer;
        }
    }
}

