/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.actionlog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import net.luckperms.api.actionlog.Action;

public class Log {
    private static final Log EMPTY = new Log((List<LoggedAction>)ImmutableList.of());
    private final SortedSet<LoggedAction> content;

    public static Builder builder() {
        return new Builder();
    }

    public static Log empty() {
        return EMPTY;
    }

    Log(List<LoggedAction> content) {
        this.content = ImmutableSortedSet.copyOf(content);
    }

    public SortedSet<LoggedAction> getContent() {
        return this.content;
    }

    public SortedSet<LoggedAction> getContent(UUID actor) {
        return (SortedSet)this.content.stream().filter(e -> e.getSource().getUniqueId().equals(actor)).collect(ImmutableCollectors.toSortedSet());
    }

    public SortedSet<LoggedAction> getUserHistory(UUID uniqueId) {
        return (SortedSet)this.content.stream().filter(e -> e.getTarget().getType() == Action.Target.Type.USER).filter(e -> e.getTarget().getUniqueId().isPresent() && e.getTarget().getUniqueId().get().equals(uniqueId)).collect(ImmutableCollectors.toSortedSet());
    }

    public SortedSet<LoggedAction> getGroupHistory(String name) {
        return (SortedSet)this.content.stream().filter(e -> e.getTarget().getType() == Action.Target.Type.GROUP).filter(e -> e.getTarget().getName().equals(name)).collect(ImmutableCollectors.toSortedSet());
    }

    public SortedSet<LoggedAction> getTrackHistory(String name) {
        return (SortedSet)this.content.stream().filter(e -> e.getTarget().getType() == Action.Target.Type.TRACK).filter(e -> e.getTarget().getName().equals(name)).collect(ImmutableCollectors.toSortedSet());
    }

    public SortedSet<LoggedAction> getSearch(String query) {
        return (SortedSet)this.content.stream().filter(e -> e.matchesSearch(query)).collect(ImmutableCollectors.toSortedSet());
    }

    public static class Builder {
        private final List<LoggedAction> content = new ArrayList<LoggedAction>();

        public Builder add(LoggedAction e) {
            this.content.add(e);
            return this;
        }

        public Log build() {
            if (this.content.isEmpty()) {
                return EMPTY;
            }
            return new Log(this.content);
        }
    }
}

