/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.context.contextset.MutableContextSetImpl;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import net.luckperms.api.context.ContextSet;

public final class ContextSetConfigurateSerializer {
    private ContextSetConfigurateSerializer() {
    }

    public static ConfigurationNode serializeContextSet(ContextSet contextSet) {
        ConfigurationNode data = ConfigurationNode.root();
        Map<String, Set<String>> map = contextSet.toMap();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            ArrayList values = new ArrayList(entry.getValue());
            int size = values.size();
            if (size == 1) {
                data.getNode(new Object[]{entry.getKey()}).setValue(values.get(0));
                continue;
            }
            if (size <= 1) continue;
            data.getNode(new Object[]{entry.getKey()}).setValue(values);
        }
        return data;
    }

    public static ContextSet deserializeContextSet(ConfigurationNode data) {
        Preconditions.checkArgument((boolean)data.isMap());
        Map dataMap = data.getChildrenMap();
        if (dataMap.isEmpty()) {
            return ImmutableContextSetImpl.EMPTY;
        }
        MutableContextSetImpl map = new MutableContextSetImpl();
        for (Map.Entry e : dataMap.entrySet()) {
            String k = e.getKey().toString();
            ConfigurationNode v = (ConfigurationNode)e.getValue();
            if (v.isList()) {
                for (ConfigurationNode value : v.getChildrenList()) {
                    map.add(k, value.getString());
                }
                continue;
            }
            map.add(k, v.getString());
        }
        return map;
    }
}

