/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node;

import me.lucko.luckperms.common.node.AbstractNode;
import net.luckperms.api.node.NodeEqualityPredicate;

public enum NodeEquality {
    KEY_VALUE_EXPIRY_CONTEXTS{

        @Override
        public boolean equals(AbstractNode<?, ?> o1, AbstractNode<?, ?> o2) {
            return o1 == o2 || o1.key.equals(o2.key) && o1.value == o2.value && o1.expireAt == o2.expireAt && o1.getContexts().equals(o2.getContexts());
        }
    }
    ,
    KEY_EXPIRY_CONTEXTS{

        @Override
        public boolean equals(AbstractNode<?, ?> o1, AbstractNode<?, ?> o2) {
            return o1 == o2 || o1.key.equals(o2.key) && o1.expireAt == o2.expireAt && o1.getContexts().equals(o2.getContexts());
        }
    }
    ,
    KEY_VALUE_HASEXPIRY_CONTEXTS{

        @Override
        public boolean equals(AbstractNode<?, ?> o1, AbstractNode<?, ?> o2) {
            return o1 == o2 || o1.key.equals(o2.key) && o1.value == o2.value && o1.hasExpiry() == o2.hasExpiry() && o1.getContexts().equals(o2.getContexts());
        }
    }
    ,
    KEY_HASEXPIRY_CONTEXTS{

        @Override
        public boolean equals(AbstractNode<?, ?> o1, AbstractNode<?, ?> o2) {
            return o1 == o2 || o1.key.equals(o2.key) && o1.hasExpiry() == o2.hasExpiry() && o1.getContexts().equals(o2.getContexts());
        }
    }
    ,
    KEY_CONTEXTS{

        @Override
        public boolean equals(AbstractNode<?, ?> o1, AbstractNode<?, ?> o2) {
            return o1 == o2 || o1.key.equals(o2.key) && o1.getContexts().equals(o2.getContexts());
        }
    }
    ,
    KEY{

        @Override
        public boolean equals(AbstractNode<?, ?> o1, AbstractNode<?, ?> o2) {
            return o1 == o2 || o1.key.equals(o2.key);
        }
    };


    public abstract boolean equals(AbstractNode<?, ?> var1, AbstractNode<?, ?> var2);

    public boolean comparesContexts() {
        return this != KEY;
    }

    public static NodeEquality of(NodeEqualityPredicate equalityPredicate) {
        if (equalityPredicate == NodeEqualityPredicate.EXACT) {
            return KEY_VALUE_EXPIRY_CONTEXTS;
        }
        if (equalityPredicate == NodeEqualityPredicate.IGNORE_VALUE) {
            return KEY_EXPIRY_CONTEXTS;
        }
        if (equalityPredicate == NodeEqualityPredicate.IGNORE_EXPIRY_TIME) {
            return KEY_VALUE_HASEXPIRY_CONTEXTS;
        }
        if (equalityPredicate == NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE) {
            return KEY_HASEXPIRY_CONTEXTS;
        }
        if (equalityPredicate == NodeEqualityPredicate.IGNORE_VALUE_OR_IF_TEMPORARY) {
            return KEY_CONTEXTS;
        }
        if (equalityPredicate == NodeEqualityPredicate.ONLY_KEY) {
            return KEY;
        }
        return null;
    }

    public static boolean comparesContexts(NodeEqualityPredicate equalityPredicate) {
        NodeEquality nodeEquality = NodeEquality.of(equalityPredicate);
        return nodeEquality != null && nodeEquality.comparesContexts();
    }
}

