/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.types;

import java.util.Map;
import java.util.Objects;
import me.lucko.luckperms.common.node.AbstractNode;
import me.lucko.luckperms.common.node.AbstractNodeBuilder;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import net.luckperms.api.node.types.InheritanceNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Inheritance
extends AbstractNode<InheritanceNode, InheritanceNode.Builder>
implements InheritanceNode {
    private static final String NODE_KEY = "group";
    private static final String NODE_MARKER = "group.";
    private final String groupName;

    public static String key(String groupName) {
        return NODE_MARKER + groupName.toLowerCase();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupName) {
        return Inheritance.builder().group(groupName);
    }

    public Inheritance(String groupName, boolean value, long expireAt, ImmutableContextSet contexts, Map<NodeMetadataKey<?>, Object> metadata) {
        super(Inheritance.key(groupName), value, expireAt, contexts, metadata);
        this.groupName = groupName.toLowerCase();
    }

    @Override
    public @NonNull String getGroupName() {
        return this.groupName;
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this.groupName, this.value, this.expireAt, this.contexts, this.metadata);
    }

    public static @Nullable Builder parse(String key) {
        if (!(key = key.toLowerCase()).startsWith(NODE_MARKER)) {
            return null;
        }
        return Inheritance.builder().group(key.substring(NODE_MARKER.length()));
    }

    public static final class Builder
    extends AbstractNodeBuilder<InheritanceNode, InheritanceNode.Builder>
    implements InheritanceNode.Builder {
        private String groupName;

        private Builder() {
            this.groupName = null;
        }

        public Builder(String groupName, boolean value, long expireAt, ImmutableContextSet context, Map<NodeMetadataKey<?>, Object> metadata) {
            super(value, expireAt, context, metadata);
            this.groupName = groupName;
        }

        @Override
        public @NonNull Builder group(@NonNull String group) {
            this.groupName = Objects.requireNonNull(group, Inheritance.NODE_KEY);
            return this;
        }

        @Override
        public @NonNull Builder group(@NonNull Group group) {
            this.groupName = Objects.requireNonNull(group, Inheritance.NODE_KEY).getName();
            return this;
        }

        @Override
        public @NonNull Inheritance build() {
            Objects.requireNonNull(this.groupName, "groupName");
            return new Inheritance(this.groupName, this.value, this.expireAt, this.context.build(), this.metadata);
        }
    }
}

