/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.hikari;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.HikariConnectionFactory;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.hikari.HikariConfig;

public class MariaDbConnectionFactory
extends HikariConnectionFactory {
    public MariaDbConnectionFactory(StorageCredentials configuration) {
        super(configuration);
    }

    @Override
    public String getImplementationName() {
        return "MariaDB";
    }

    @Override
    protected String defaultPort() {
        return "3306";
    }

    @Override
    protected void configureDatabase(HikariConfig config, String address, String port, String databaseName, String username, String password) {
        config.setDataSourceClassName("me.lucko.luckperms.lib.mariadb.MariaDbDataSource");
        config.addDataSourceProperty("serverName", (Object)address);
        config.addDataSourceProperty("port", (Object)port);
        config.addDataSourceProperty("databaseName", (Object)databaseName);
        config.setUsername(username);
        config.setPassword(password);
    }

    @Override
    protected void setProperties(HikariConfig config, Map<String, String> properties) {
        String propertiesString = properties.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";"));
        config.addDataSourceProperty("properties", (Object)propertiesString);
    }

    @Override
    public Function<String, String> getStatementProcessor() {
        return s -> s.replace('\'', '`');
    }
}

