/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import me.lucko.luckperms.common.calculator.result.TristateResult;
import me.lucko.luckperms.common.http.AbstractHttpClient;
import me.lucko.luckperms.common.http.BytebinClient;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.StackTracePrinter;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.util.gson.JArray;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.VerboseFilter;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import me.lucko.luckperms.common.verbose.event.PermissionCheckEvent;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEventSource;
import me.lucko.luckperms.lib.adventure.text.format.NamedTextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;
import net.luckperms.api.query.QueryMode;

public class VerboseListener {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.systemDefault());
    private static final int DATA_TRUNCATION = 10000;
    private static final int STACK_TRUNCATION_CHAT = 15;
    private static final int STACK_TRUNCATION_WEB = 40;
    private static final StackTracePrinter FILTERING_PRINTER = StackTracePrinter.builder().ignoreClassStartingWith("me.lucko.luckperms.").ignoreClass("java.util.concurrent.CompletableFuture").ignoreClass("java.util.concurrent.ConcurrentHashMap").build();
    private static final StackTracePrinter CHAT_FILTERED_PRINTER = FILTERING_PRINTER.toBuilder().truncateLength(15).build();
    private static final StackTracePrinter CHAT_UNFILTERED_PRINTER = StackTracePrinter.builder().truncateLength(15).build();
    private static final StackTracePrinter WEB_FILTERED_PRINTER = FILTERING_PRINTER.toBuilder().truncateLength(40).build();
    private static final StackTracePrinter WEB_UNFILTERED_PRINTER = StackTracePrinter.builder().truncateLength(40).build();
    private final Instant startTime = Instant.now();
    private final Sender notifiedSender;
    private final VerboseFilter filter;
    private final boolean notify;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final AtomicInteger matchedCounter = new AtomicInteger(0);
    private final List<VerboseEvent> results = new ArrayList<VerboseEvent>(1000);

    public VerboseListener(Sender notifiedSender, VerboseFilter filter, boolean notify) {
        this.notifiedSender = notifiedSender;
        this.filter = filter;
        this.notify = notify;
    }

    public void acceptEvent(VerboseEvent event) {
        this.counter.incrementAndGet();
        if (!this.filter.evaluate(event)) {
            return;
        }
        this.matchedCounter.incrementAndGet();
        if (this.results.size() < 10000) {
            this.results.add(event);
        }
        if (this.notify) {
            this.sendNotification(event);
        }
    }

    private void sendNotification(VerboseEvent event) {
        Component component;
        if (this.notifiedSender.isConsole()) {
            if (event instanceof PermissionCheckEvent) {
                PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
                Message.VERBOSE_LOG_PERMISSION.send(this.notifiedSender, permissionEvent.getCheckTarget(), permissionEvent.getPermission(), permissionEvent.getResult().result());
            } else if (event instanceof MetaCheckEvent) {
                MetaCheckEvent metaEvent = (MetaCheckEvent)event;
                Message.VERBOSE_LOG_META.send(this.notifiedSender, metaEvent.getCheckTarget(), metaEvent.getKey(), metaEvent.getResult());
            } else {
                throw new IllegalArgumentException("Unknown event type: " + event);
            }
            return;
        }
        if (event instanceof PermissionCheckEvent) {
            PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
            component = Message.VERBOSE_LOG_PERMISSION.build(permissionEvent.getCheckTarget(), permissionEvent.getPermission(), permissionEvent.getResult().result());
        } else if (event instanceof MetaCheckEvent) {
            MetaCheckEvent metaEvent = (MetaCheckEvent)event;
            component = Message.VERBOSE_LOG_META.build(metaEvent.getCheckTarget(), metaEvent.getKey(), metaEvent.getResult());
        } else {
            throw new IllegalArgumentException("Unknown event type: " + event);
        }
        ArrayList<Object> hover = new ArrayList<Object>();
        if (event instanceof PermissionCheckEvent) {
            PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
            hover.add(((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Type: ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"permission", (TextColor)NamedTextColor.DARK_GREEN)));
            hover.add(((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Origin: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)permissionEvent.getOrigin().name(), (TextColor)NamedTextColor.DARK_GREEN)));
            TristateResult result = permissionEvent.getResult();
            if (result.processorClass() != null) {
                hover.add(((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Processor: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)result.processorClass().getName(), (TextColor)NamedTextColor.DARK_GREEN)));
            }
            if (result.cause() != null) {
                hover.add(((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Cause: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)result.cause(), (TextColor)NamedTextColor.DARK_GREEN)));
            }
        }
        if (event instanceof MetaCheckEvent) {
            MetaCheckEvent metaEvent = (MetaCheckEvent)event;
            hover.add(((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Type: ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"meta", (TextColor)NamedTextColor.DARK_GREEN)));
            hover.add(((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Origin: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)metaEvent.getOrigin().name(), (TextColor)NamedTextColor.DARK_GREEN)));
        }
        if (event.getCheckQueryOptions().mode() == QueryMode.CONTEXTUAL) {
            hover.add(((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Context: ", (TextColor)NamedTextColor.AQUA))).append(Message.formatContextSet(event.getCheckQueryOptions().context())));
        }
        hover.add(((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Thread: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)event.getCheckThread(), (TextColor)NamedTextColor.WHITE)));
        hover.add(Component.text().append((Component)Component.text((String)"Trace: ", (TextColor)NamedTextColor.AQUA)));
        Consumer<StackTraceElement> printer = StackTracePrinter.elementToString(str -> hover.add(Component.text((String)str, (TextColor)NamedTextColor.GRAY)));
        int overflow = VerboseListener.shouldFilterStackTrace(event) ? CHAT_FILTERED_PRINTER.process(event.getCheckTrace(), printer) : CHAT_UNFILTERED_PRINTER.process(event.getCheckTrace(), printer);
        if (overflow != 0) {
            hover.add(Component.text((String)("... and " + overflow + " more"), (TextColor)NamedTextColor.WHITE));
        }
        HoverEvent hoverEvent = HoverEvent.showText((Component)Component.join((ComponentLike)Component.newline(), hover));
        this.notifiedSender.sendMessage(component.hoverEvent((HoverEventSource)hoverEvent));
    }

    private static boolean shouldFilterStackTrace(VerboseEvent event) {
        if (event instanceof PermissionCheckEvent) {
            PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
            return permissionEvent.getOrigin() == PermissionCheckEvent.Origin.PLATFORM_LOOKUP_CHECK || permissionEvent.getOrigin() == PermissionCheckEvent.Origin.PLATFORM_PERMISSION_CHECK;
        }
        return false;
    }

    public String uploadPasteData(BytebinClient bytebin) throws IOException, UnsuccessfulRequestException {
        String startDate = DATE_FORMAT.format(this.startTime);
        String endDate = DATE_FORMAT.format(Instant.now());
        String duration = DurationFormatter.CONCISE.formatString(Duration.between(this.startTime, Instant.now()));
        boolean truncated = this.matchedCounter.get() > this.results.size();
        JObject metadata = new JObject().add("startTime", startDate).add("endTime", endDate).add("duration", duration).add("count", new JObject().add("matched", this.matchedCounter.get()).add("total", this.counter.get())).add("uploader", new JObject().add("name", this.notifiedSender.getNameWithLocation()).add("uuid", this.notifiedSender.getUniqueId().toString())).add("filter", this.filter.toString()).add("truncated", truncated);
        JArray data = new JArray();
        for (VerboseEvent events : this.results) {
            data.add((JsonElement)events.toJson(VerboseListener.shouldFilterStackTrace(events) ? WEB_FILTERED_PRINTER : WEB_UNFILTERED_PRINTER));
        }
        this.results.clear();
        JsonObject payload = new JObject().add("metadata", metadata).add("data", data).toJson();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(bytesOut), StandardCharsets.UTF_8);){
            GsonProvider.normal().toJson((JsonElement)payload, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytebin.postContent(bytesOut.toByteArray(), AbstractHttpClient.JSON_TYPE).key();
    }

    public Sender getNotifiedSender() {
        return this.notifiedSender;
    }

    public int getMatchedCount() {
        return this.matchedCounter.get();
    }
}

