/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.context;

import java.util.Set;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.CatalogTypes;
import org.spongepowered.api.Game;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.ChangeGameModeEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.World;

public class SpongePlayerCalculator
implements ContextCalculator<Subject> {
    private final LPSpongePlugin plugin;
    private final boolean gamemode;
    private final boolean world;
    private final boolean dimensionType;

    public SpongePlayerCalculator(LPSpongePlugin plugin, Set<String> disabled) {
        this.plugin = plugin;
        this.gamemode = !disabled.contains("gamemode");
        this.world = !disabled.contains("world");
        this.dimensionType = !disabled.contains("dimension-type");
    }

    @Override
    public void calculate(@NonNull Subject subject, @NonNull ContextConsumer consumer) {
        CommandSource source = subject.getCommandSource().orElse(null);
        if (source == null) {
            return;
        }
        if (source instanceof Locatable) {
            World world = ((Locatable)source).getWorld();
            if (this.dimensionType) {
                consumer.accept("dimension-type", SpongePlayerCalculator.getCatalogTypeName((CatalogType)world.getDimension().getType()));
            }
            if (this.world) {
                this.plugin.getConfiguration().get(ConfigKeys.WORLD_REWRITES).rewriteAndSubmit(world.getName(), consumer);
            }
        }
        if (this.gamemode && source instanceof ValueContainer) {
            ValueContainer valueContainer = (ValueContainer)source;
            valueContainer.get(Keys.GAME_MODE).ifPresent(mode -> consumer.accept("gamemode", SpongePlayerCalculator.getCatalogTypeName((CatalogType)mode)));
        }
    }

    @Override
    public ContextSet estimatePotentialContexts() {
        ImmutableContextSetImpl.BuilderImpl builder = new ImmutableContextSetImpl.BuilderImpl();
        Game game = this.plugin.getBootstrap().getGame();
        if (this.gamemode) {
            for (GameMode mode : game.getRegistry().getAllOf(CatalogTypes.GAME_MODE)) {
                builder.add("gamemode", SpongePlayerCalculator.getCatalogTypeName((CatalogType)mode));
            }
        }
        if (this.dimensionType) {
            for (DimensionType dim : game.getRegistry().getAllOf(CatalogTypes.DIMENSION_TYPE)) {
                builder.add("dimension-type", SpongePlayerCalculator.getCatalogTypeName((CatalogType)dim));
            }
        }
        if (this.world && game.isServerAvailable()) {
            for (World world : game.getServer().getWorlds()) {
                String worldName = world.getName();
                if (!Context.isValidValue(worldName)) continue;
                builder.add("world", worldName);
            }
        }
        return builder.build();
    }

    private static String getCatalogTypeName(CatalogType type) {
        String id = type.getId();
        if (id.startsWith("minecraft:")) {
            return id.substring("minecraft:".length());
        }
        return id;
    }

    @Listener(order=Order.LAST)
    public void onWorldChange(MoveEntityEvent.Teleport e) {
        if (!this.world && !this.dimensionType) {
            return;
        }
        Entity targetEntity = e.getTargetEntity();
        if (!(targetEntity instanceof Subject)) {
            return;
        }
        if (((World)e.getFromTransform().getExtent()).equals(e.getToTransform().getExtent())) {
            return;
        }
        this.plugin.getContextManager().signalContextUpdate((Subject)targetEntity);
    }

    @Listener(order=Order.LAST)
    public void onGameModeChange(ChangeGameModeEvent e) {
        Humanoid targetEntity = e.getTargetEntity();
        if (this.gamemode && targetEntity instanceof Subject) {
            this.plugin.getContextManager().signalContextUpdate((Subject)targetEntity);
        }
    }
}

