/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.model.manager;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.model.manager.user.AbstractUserManager;
import me.lucko.luckperms.common.model.manager.user.UserHousekeeper;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.common.util.Uuids;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.model.SpongeUser;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.ProxyFactory;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.util.Tristate;
import org.spongepowered.api.service.permission.SubjectCollection;

public class SpongeUserManager
extends AbstractUserManager<SpongeUser>
implements LPSubjectCollection {
    private final LPSpongePlugin plugin;
    private final LoadingCache<UUID, LPSubject> subjectLoadingCache;
    private SubjectCollection spongeProxy = null;

    public SpongeUserManager(LPSpongePlugin plugin) {
        super(plugin, UserHousekeeper.timeoutSettings(10L, TimeUnit.MINUTES));
        this.plugin = plugin;
        this.subjectLoadingCache = Caffeine.newBuilder().executor(this.plugin.getBootstrap().getScheduler().async()).expireAfterWrite(1L, TimeUnit.MINUTES).build(u -> {
            this.getHouseKeeper().registerUsage((UUID)u);
            SpongeUser user = (SpongeUser)this.getIfLoaded(u);
            if (user != null) {
                return user.sponge();
            }
            this.getPlugin().getStorage().loadUser((UUID)u, null).join();
            user = (SpongeUser)this.getIfLoaded(u);
            if (user == null) {
                this.getPlugin().getLogger().severe("Error whilst loading user '" + u + "'.");
                throw new RuntimeException();
            }
            return user.sponge();
        });
    }

    @Override
    public SpongeUser apply(UUID id) {
        return new SpongeUser(id, this.plugin);
    }

    @Override
    public synchronized SubjectCollection sponge() {
        if (this.spongeProxy == null) {
            Objects.requireNonNull(this.plugin.getService(), "service");
            this.spongeProxy = ProxyFactory.toSponge(this);
        }
        return this.spongeProxy;
    }

    public LPSpongePlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public LuckPermsService getService() {
        return this.plugin.getService();
    }

    @Override
    public String getIdentifier() {
        return "user";
    }

    @Override
    public Predicate<String> getIdentifierValidityPredicate() {
        return Uuids.PREDICATE;
    }

    @Override
    public CompletableFuture<LPSubject> loadSubject(String identifier) {
        UUID uuid = Uuids.parse(identifier);
        if (uuid == null) {
            throw new IllegalArgumentException("Identifier is not a UUID: " + identifier);
        }
        LPSubject present = (LPSubject)this.subjectLoadingCache.getIfPresent((Object)uuid);
        if (present != null) {
            return CompletableFuture.completedFuture(present);
        }
        return CompletableFuture.supplyAsync(() -> (LPSubject)this.subjectLoadingCache.get((Object)uuid), this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public Optional<LPSubject> getSubject(String identifier) {
        UUID uuid = Uuids.parse(identifier);
        if (uuid == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((SpongeUser)this.getIfLoaded(uuid)).map(SpongeUser::sponge);
    }

    @Override
    public CompletableFuture<Boolean> hasRegistered(String identifier) {
        UUID uuid = Uuids.parse(identifier);
        if (uuid == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isLoaded(uuid)) {
            return CompletableFuture.completedFuture(true);
        }
        return this.plugin.getStorage().getUniqueUsers().thenApply(set -> set.contains(uuid));
    }

    @Override
    public CompletableFuture<ImmutableCollection<LPSubject>> loadSubjects(Set<String> identifiers) {
        return CompletableFuture.supplyAsync(() -> {
            ImmutableSet.Builder subjects = ImmutableSet.builder();
            for (String id : identifiers) {
                UUID uuid = Uuids.parse(id);
                if (uuid == null) continue;
                subjects.add((Object)this.loadSubject(uuid.toString()).join());
            }
            return subjects.build();
        }, this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public ImmutableCollection<LPSubject> getLoadedSubjects() {
        return (ImmutableCollection)this.getAll().values().stream().map(SpongeUser::sponge).collect(ImmutableCollectors.toSet());
    }

    @Override
    public CompletableFuture<ImmutableSet<String>> getAllIdentifiers() {
        return CompletableFuture.supplyAsync(() -> {
            ImmutableSet.Builder ids = ImmutableSet.builder();
            this.getAll().keySet().forEach(uuid -> ids.add((Object)uuid.toString()));
            this.plugin.getStorage().getUniqueUsers().join().forEach(uuid -> ids.add((Object)uuid.toString()));
            return ids.build();
        }, this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public CompletableFuture<ImmutableMap<LPSubjectReference, Boolean>> getAllWithPermission(String permission) {
        return CompletableFuture.supplyAsync(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            List<NodeEntry<UUID, String>> lookup = this.plugin.getStorage().searchUserNodes(StandardNodeMatchers.key(permission)).join();
            for (NodeEntry<UUID, String> holder : lookup) {
                if (!holder.getNode().getContexts().equals(ImmutableContextSetImpl.EMPTY)) continue;
                builder.put((Object)this.getService().getReferenceFactory().obtain(this.getIdentifier(), ((UUID)holder.getHolder()).toString()), (Object)holder.getNode().getValue());
            }
            return builder.build();
        }, this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public CompletableFuture<ImmutableMap<LPSubjectReference, Boolean>> getAllWithPermission(ImmutableContextSet contexts, String permission) {
        return CompletableFuture.supplyAsync(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            List<NodeEntry<UUID, String>> lookup = this.plugin.getStorage().searchUserNodes(StandardNodeMatchers.key(permission)).join();
            for (NodeEntry<UUID, String> holder : lookup) {
                if (!holder.getNode().getContexts().equals(contexts)) continue;
                builder.put((Object)this.getService().getReferenceFactory().obtain(this.getIdentifier(), ((UUID)holder.getHolder()).toString()), (Object)holder.getNode().getValue());
            }
            return builder.build();
        }, this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public ImmutableMap<LPSubject, Boolean> getLoadedWithPermission(String permission) {
        return this.getAll().values().stream().map(SpongeUser::sponge).map(sub -> Maps.immutableEntry((Object)sub, (Object)((Object)sub.getPermissionValue(ImmutableContextSetImpl.EMPTY, permission)))).filter(pair -> pair.getValue() != Tristate.UNDEFINED).collect(ImmutableCollectors.toMap(Map.Entry::getKey, sub -> ((Tristate)((Object)((Object)sub.getValue()))).asBoolean()));
    }

    @Override
    public ImmutableMap<LPSubject, Boolean> getLoadedWithPermission(ImmutableContextSet contexts, String permission) {
        return this.getAll().values().stream().map(SpongeUser::sponge).map(sub -> Maps.immutableEntry((Object)sub, (Object)((Object)sub.getPermissionValue(contexts, permission)))).filter(pair -> pair.getValue() != Tristate.UNDEFINED).collect(ImmutableCollectors.toMap(Map.Entry::getKey, sub -> ((Tristate)((Object)((Object)sub.getValue()))).asBoolean()));
    }

    @Override
    public LPSubject getDefaults() {
        return this.getService().getDefaultSubjects().getTypeDefaults(this.getIdentifier());
    }
}

