/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.common.context.contextset.ContextImpl;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.sponge.service.context.ForwardingContextSet;
import me.lucko.luckperms.sponge.service.context.ForwardingImmutableContextSet;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.util.Tristate;
import org.spongepowered.api.service.context.Context;

public final class CompatibilityUtil {
    private static final Set<Context> EMPTY = ImmutableSet.of();

    private CompatibilityUtil() {
    }

    public static ImmutableContextSet convertContexts(Set<Context> contexts) {
        Objects.requireNonNull(contexts, "contexts");
        if (contexts instanceof ForwardingContextSet) {
            return ((ForwardingContextSet)contexts).delegate().immutableCopy();
        }
        if (contexts.isEmpty()) {
            return ImmutableContextSetImpl.EMPTY;
        }
        ImmutableContextSetImpl.BuilderImpl builder = new ImmutableContextSetImpl.BuilderImpl();
        for (Map.Entry entry : contexts) {
            builder.add(new ContextImpl((String)entry.getKey(), (String)entry.getValue()));
        }
        return builder.build();
    }

    public static Set<Context> convertContexts(ContextSet contexts) {
        Objects.requireNonNull(contexts, "contexts");
        if (contexts.isEmpty()) {
            return EMPTY;
        }
        return new ForwardingImmutableContextSet(contexts.immutableCopy());
    }

    public static org.spongepowered.api.util.Tristate convertTristate(Tristate tristate) {
        Objects.requireNonNull(tristate, "tristate");
        switch (tristate) {
            case TRUE: {
                return org.spongepowered.api.util.Tristate.TRUE;
            }
            case FALSE: {
                return org.spongepowered.api.util.Tristate.FALSE;
            }
        }
        return org.spongepowered.api.util.Tristate.UNDEFINED;
    }

    public static Tristate convertTristate(org.spongepowered.api.util.Tristate tristate) {
        Objects.requireNonNull(tristate, "tristate");
        switch (tristate) {
            case TRUE: {
                return Tristate.TRUE;
            }
            case FALSE: {
                return Tristate.FALSE;
            }
        }
        return Tristate.UNDEFINED;
    }
}

