/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy.api6;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.sponge.service.CompatibilityUtil;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.model.ProxiedServiceObject;
import me.lucko.luckperms.sponge.service.proxy.api6.SubjectProxy;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;

public final class SubjectCollectionProxy
implements SubjectCollection,
ProxiedServiceObject {
    private final LPPermissionService service;
    private final LPSubjectCollection handle;

    public SubjectCollectionProxy(LPPermissionService service, LPSubjectCollection handle) {
        this.service = service;
        this.handle = handle;
    }

    public @NonNull String getIdentifier() {
        return this.handle.getIdentifier();
    }

    public @NonNull Subject get(@NonNull String s) {
        return (Subject)((CompletableFuture)this.handle.loadSubject(s).thenApply(LPSubject::sponge)).join();
    }

    public boolean hasRegistered(@NonNull String s) {
        return this.handle.hasRegistered(s).join();
    }

    public @NonNull Iterable<Subject> getAllSubjects() {
        return (List)((CompletableFuture)this.handle.getAllIdentifiers().thenApply(ids -> ids.stream().map(s -> new SubjectProxy(this.service, this.service.getReferenceFactory().obtain(this.getIdentifier(), (String)s))).collect(ImmutableCollectors.toList()))).join();
    }

    public @NonNull Map<Subject, Boolean> getAllWithPermission(@NonNull String s) {
        return (Map)((CompletableFuture)this.handle.getAllWithPermission(s).thenApply(map -> map.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new SubjectProxy(this.service, (LPSubjectReference)e.getKey()), Map.Entry::getValue)))).join();
    }

    public @NonNull Map<Subject, Boolean> getAllWithPermission(@NonNull Set<Context> set, @NonNull String s) {
        return (Map)((CompletableFuture)this.handle.getAllWithPermission(CompatibilityUtil.convertContexts(set), s).thenApply(map -> map.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new SubjectProxy(this.service, (LPSubjectReference)e.getKey()), Map.Entry::getValue)))).join();
    }

    public @NonNull Subject getDefaults() {
        return this.handle.getDefaults().sponge();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SubjectCollectionProxy && this.handle.equals(((SubjectCollectionProxy)o).handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "luckperms.api6.SubjectCollectionProxy(handle=" + this.handle + ")";
    }
}

