/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.crafting;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.spongepowered.api.GameDictionary;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.generator.dummy.DummyObjectProvider;

public interface Ingredient
extends Predicate<ItemStack> {
    public static final Ingredient NONE = DummyObjectProvider.createFor(Ingredient.class, "NONE");

    @Override
    public boolean test(ItemStack var1);

    public List<ItemStackSnapshot> displayedItems();

    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public static Ingredient of(ItemStackSnapshot ... snapshots) {
        if (snapshots == null || snapshots.length == 0) {
            return NONE;
        }
        return Ingredient.builder().with(snapshots).build();
    }

    public static Ingredient of(ItemStack ... itemStacks) {
        if (itemStacks == null || itemStacks.length == 0) {
            return NONE;
        }
        return Ingredient.builder().with(itemStacks).build();
    }

    public static Ingredient of(ItemType ... itemTypes) {
        if (itemTypes == null || itemTypes.length == 0) {
            return NONE;
        }
        return Ingredient.builder().with(itemTypes).build();
    }

    public static Ingredient of(GameDictionary.Entry ... entries) {
        if (entries == null || entries.length == 0) {
            return NONE;
        }
        return Ingredient.builder().with(i -> Arrays.stream(entries).anyMatch(e -> e.matches((ItemStack)i))).build();
    }

    public static interface Builder
    extends ResettableBuilder<Ingredient, Builder> {
        public Builder with(Predicate<ItemStack> var1);

        default public Builder with(GameDictionary.Entry entry) {
            return this.with(entry::matches).withDisplay(entry.getTemplate());
        }

        public Builder with(ItemType ... var1);

        public Builder with(ItemStack ... var1);

        public Builder with(ItemStackSnapshot ... var1);

        public Builder withDisplay(ItemType ... var1);

        public Builder withDisplay(ItemStack ... var1);

        public Builder withDisplay(ItemStackSnapshot ... var1);

        public Ingredient build();
    }
}

