/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.block.tileentity;

import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import org.spongepowered.api.block.tileentity.carrier.Furnace;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.builder.block.tileentity.SpongeLockableBuilder;
import org.spongepowered.common.util.Constants;

public class SpongeFurnaceBuilder
extends SpongeLockableBuilder<Furnace> {
    public SpongeFurnaceBuilder() {
        super(Furnace.class, 1);
    }

    @Override
    protected Optional<Furnace> buildContent(DataView container) throws InvalidDataException {
        return super.buildContent(container).flatMap(furnace -> {
            TileEntityFurnace tileEntityFurnace = (TileEntityFurnace)furnace;
            if (container.contains(Constants.TileEntity.CUSTOM_NAME)) {
                tileEntityFurnace.func_145951_a(container.getString(Constants.TileEntity.CUSTOM_NAME).get());
            }
            if (!container.contains(Keys.PASSED_BURN_TIME.getQuery(), Keys.MAX_BURN_TIME.getQuery(), Keys.PASSED_COOK_TIME.getQuery(), Keys.MAX_COOK_TIME.getQuery())) {
                ((TileEntity)furnace).func_145843_s();
                return Optional.empty();
            }
            int burnTime = container.getInt(Keys.PASSED_BURN_TIME.getQuery()).get();
            int maxBurnTime = container.getInt(Keys.MAX_BURN_TIME.getQuery()).get();
            int passedCookTime = container.getInt(Keys.PASSED_COOK_TIME.getQuery()).get();
            int maxCookTime = container.getInt(Keys.MAX_COOK_TIME.getQuery()).get();
            tileEntityFurnace.func_174885_b(0, maxBurnTime - burnTime);
            tileEntityFurnace.func_174885_b(1, maxBurnTime);
            tileEntityFurnace.func_174885_b(2, passedCookTime);
            tileEntityFurnace.func_174885_b(3, maxCookTime);
            tileEntityFurnace.func_70296_d();
            return Optional.of(furnace);
        });
    }
}

