/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.base.Preconditions;
import java.time.Instant;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableJoinData;
import org.spongepowered.api.data.manipulator.mutable.entity.JoinData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeJoinData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeJoinData
extends AbstractData<JoinData, ImmutableJoinData>
implements JoinData {
    private Instant firstJoined;
    private Instant lastJoined;

    public SpongeJoinData() {
        this(Instant.now(), Instant.now());
    }

    public SpongeJoinData(Instant firstJoined, Instant lastJoined) {
        super(JoinData.class);
        this.firstJoined = firstJoined;
        this.lastJoined = lastJoined;
        this.registerGettersAndSetters();
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.FIRST_DATE_PLAYED, () -> this.firstJoined);
        this.registerFieldSetter(Keys.FIRST_DATE_PLAYED, instant -> {
            this.firstJoined = (Instant)Preconditions.checkNotNull((Object)instant, (Object)"First join instant cannot be null!");
        });
        this.registerKeyValue(Keys.FIRST_DATE_PLAYED, this::firstPlayed);
        this.registerFieldGetter(Keys.LAST_DATE_PLAYED, () -> this.lastJoined);
        this.registerFieldSetter(Keys.LAST_DATE_PLAYED, instant -> {
            this.lastJoined = (Instant)Preconditions.checkNotNull((Object)instant, (Object)"Last join instant cannot be null!");
        });
        this.registerKeyValue(Keys.LAST_DATE_PLAYED, this::lastPlayed);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.FIRST_DATE_PLAYED.getQuery(), (Object)this.firstJoined.toEpochMilli()).set(Keys.LAST_DATE_PLAYED.getQuery(), (Object)this.lastJoined.toEpochMilli());
    }

    @Override
    public Value<Instant> firstPlayed() {
        return new SpongeValue<Instant>(Keys.FIRST_DATE_PLAYED, Instant.EPOCH, this.firstJoined);
    }

    @Override
    public Value<Instant> lastPlayed() {
        return new SpongeValue<Instant>(Keys.LAST_DATE_PLAYED, Instant.EPOCH, this.lastJoined);
    }

    @Override
    public JoinData copy() {
        return new SpongeJoinData(this.firstJoined, this.lastJoined);
    }

    @Override
    public ImmutableJoinData asImmutable() {
        return new ImmutableSpongeJoinData(this.firstJoined, this.lastJoined);
    }
}

