/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.tileentity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableFurnaceData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.FurnaceData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.tileentity.ImmutableSpongeFurnaceData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class SpongeFurnaceData
extends AbstractData<FurnaceData, ImmutableFurnaceData>
implements FurnaceData {
    private int passedBurnTime;
    private int maxBurnTime;
    private int passedCookTime;
    private int maxCookTime;

    public SpongeFurnaceData() {
        this(0, 0, 0, 0);
    }

    public SpongeFurnaceData(int passedBurnTime, int maxBurnTime, int passedCookTime, int maxCookTime) {
        super(FurnaceData.class);
        this.passedBurnTime = passedBurnTime;
        this.maxBurnTime = maxBurnTime;
        this.passedCookTime = passedCookTime;
        this.maxCookTime = maxCookTime;
        this.registerGettersAndSetters();
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.PASSED_BURN_TIME, this::getPassedBurnTime);
        this.registerFieldSetter(Keys.PASSED_BURN_TIME, this::setPassedBurnTime);
        this.registerKeyValue(Keys.PASSED_BURN_TIME, this::passedBurnTime);
        this.registerFieldGetter(Keys.MAX_BURN_TIME, this::getMaxBurnTime);
        this.registerFieldSetter(Keys.MAX_BURN_TIME, this::setMaxBurnTime);
        this.registerKeyValue(Keys.MAX_BURN_TIME, this::maxBurnTime);
        this.registerFieldGetter(Keys.PASSED_COOK_TIME, this::getPassedCookTime);
        this.registerFieldSetter(Keys.PASSED_COOK_TIME, this::setPassedCookTime);
        this.registerKeyValue(Keys.PASSED_COOK_TIME, this::passedCookTime);
        this.registerFieldGetter(Keys.MAX_COOK_TIME, this::getMaxCookTime);
        this.registerFieldSetter(Keys.MAX_COOK_TIME, this::setMaxCookTime);
        this.registerKeyValue(Keys.MAX_COOK_TIME, this::maxCookTime);
    }

    @Override
    public MutableBoundedValue<Integer> passedBurnTime() {
        return SpongeValueFactory.boundedBuilder(Keys.PASSED_BURN_TIME).minimum(0).maximum(this.maxBurnTime).defaultValue(0).actualValue(this.passedBurnTime).build();
    }

    public int getPassedBurnTime() {
        return this.passedBurnTime;
    }

    public void setPassedBurnTime(int passedBurnTime) {
        this.passedBurnTime = passedBurnTime;
    }

    @Override
    public MutableBoundedValue<Integer> maxBurnTime() {
        return SpongeValueFactory.boundedBuilder(Keys.MAX_BURN_TIME).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(1600).actualValue(this.maxBurnTime).build();
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public void setMaxBurnTime(int maxBurnTime) {
        this.maxBurnTime = maxBurnTime;
    }

    @Override
    public MutableBoundedValue<Integer> passedCookTime() {
        return SpongeValueFactory.boundedBuilder(Keys.PASSED_COOK_TIME).minimum(0).maximum(this.maxCookTime).defaultValue(0).actualValue(this.passedCookTime).build();
    }

    public int getPassedCookTime() {
        return this.passedCookTime;
    }

    public void setPassedCookTime(int passedCookTime) {
        this.passedCookTime = passedCookTime;
    }

    @Override
    public MutableBoundedValue<Integer> maxCookTime() {
        return SpongeValueFactory.boundedBuilder(Keys.MAX_COOK_TIME).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(200).actualValue(this.maxCookTime).build();
    }

    public int getMaxCookTime() {
        return this.maxCookTime;
    }

    public void setMaxCookTime(int maxCookTime) {
        this.maxCookTime = maxCookTime;
    }

    @Override
    public FurnaceData copy() {
        return new SpongeFurnaceData(this.passedBurnTime, this.maxBurnTime, this.passedCookTime, this.maxCookTime);
    }

    @Override
    public ImmutableFurnaceData asImmutable() {
        return new ImmutableSpongeFurnaceData(this.passedBurnTime, this.maxBurnTime, this.passedCookTime, this.maxCookTime);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.PASSED_BURN_TIME, (Object)this.passedBurnTime).set(Keys.MAX_BURN_TIME, (Object)this.maxBurnTime).set(Keys.PASSED_COOK_TIME, (Object)this.passedCookTime).set(Keys.MAX_COOK_TIME, (Object)this.maxCookTime);
    }
}

