/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

public class LastPlayedValueProcessor
extends AbstractSpongeValueProcessor<Identifiable, Instant, Value<Instant>> {
    public LastPlayedValueProcessor() {
        super(Identifiable.class, Keys.LAST_DATE_PLAYED);
    }

    @Override
    protected boolean supports(Identifiable dataHolder) {
        return dataHolder instanceof EntityPlayer || dataHolder instanceof SpongeUser;
    }

    @Override
    protected Value<Instant> constructValue(Instant actualValue) {
        return new SpongeValue<Instant>(Keys.LAST_DATE_PLAYED, Instant.now(), actualValue);
    }

    @Override
    protected boolean set(Identifiable container, Instant value) {
        UUID id = container.getUniqueId();
        Instant played = SpongePlayerDataHandler.getFirstJoined(id).get();
        SpongePlayerDataHandler.setPlayerInfo(id, played, value);
        return true;
    }

    @Override
    protected Optional<Instant> getVal(Identifiable container) {
        return SpongePlayerDataHandler.getLastPlayed(container.getUniqueId());
    }

    @Override
    protected ImmutableValue<Instant> constructImmutableValue(Instant value) {
        return new ImmutableSpongeValue<Instant>(Keys.LAST_DATE_PLAYED, Instant.now(), value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

