/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.property.store.common;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.property.PropertyHolder;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.common.data.property.store.common.AbstractSpongePropertyStore;

public abstract class AbstractBlockPropertyStore<T extends Property<?, ?>>
extends AbstractSpongePropertyStore<T> {
    private final boolean checksItemStack;

    protected AbstractBlockPropertyStore(boolean checksItemStack) {
        this.checksItemStack = checksItemStack;
    }

    protected abstract Optional<T> getForBlock(@Nullable Location<?> var1, IBlockState var2);

    protected Optional<T> getForDirection(World world, int x, int y, int z, EnumFacing facing) {
        return Optional.empty();
    }

    @Override
    public Optional<T> getFor(PropertyHolder propertyHolder) {
        if (propertyHolder instanceof Location) {
            Location location = (Location)propertyHolder;
            IBlockState block = (IBlockState)location.getBlock();
            return this.getForBlock(location, block);
        }
        if (this.checksItemStack && propertyHolder instanceof ItemStack) {
            Block block;
            Item item = ((ItemStack)propertyHolder).func_77973_b();
            if (item instanceof ItemBlock && (block = ((ItemBlock)item).func_179223_d()) != null) {
                return this.getForBlock(null, block.func_176223_P());
            }
        } else {
            if (propertyHolder instanceof IBlockState) {
                return this.getForBlock(null, (IBlockState)propertyHolder);
            }
            if (propertyHolder instanceof Block) {
                return this.getForBlock(null, ((Block)propertyHolder).func_176223_P());
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<T> getFor(Location<org.spongepowered.api.world.World> location) {
        return this.getForBlock(location, (IBlockState)location.getBlock());
    }

    @Override
    public Optional<T> getFor(Location<org.spongepowered.api.world.World> location, Direction direction) {
        return this.getForDirection((World)location.getExtent(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), AbstractBlockPropertyStore.toEnumFacing(direction));
    }
}

