/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.immutable;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableWeightedCollectionValue;
import org.spongepowered.api.data.value.mutable.WeightedCollectionValue;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeCollectionValue;
import org.spongepowered.common.data.value.mutable.SpongeWeightedCollectionValue;

public class ImmutableSpongeWeightedCollectionValue<E>
extends ImmutableSpongeCollectionValue<TableEntry<E>, WeightedTable<E>, ImmutableWeightedCollectionValue<E>, WeightedCollectionValue<E>>
implements ImmutableWeightedCollectionValue<E> {
    public ImmutableSpongeWeightedCollectionValue(Key<? extends BaseValue<WeightedTable<E>>> key, WeightedTable<E> actualValue) {
        super(key, new WeightedTable(), (Collection)actualValue.stream().collect(Collectors.toCollection(WeightedTable::new)));
    }

    @Override
    public ImmutableWeightedCollectionValue<E> with(WeightedTable<E> value) {
        return new ImmutableSpongeWeightedCollectionValue<E>(this.getKey(), value);
    }

    @Override
    public ImmutableWeightedCollectionValue<E> withElement(TableEntry<E> elements) {
        WeightedTable<E> table = new WeightedTable<E>();
        table.addAll((Collection)this.actualValue);
        table.add(elements);
        return new ImmutableSpongeWeightedCollectionValue(this.getKey(), table);
    }

    @Override
    public ImmutableWeightedCollectionValue<E> transform(Function<WeightedTable<E>, WeightedTable<E>> function) {
        Collection table = this.getAll();
        WeightedTable<E> functionTable = function.apply((WeightedTable<E>)table);
        return new ImmutableSpongeWeightedCollectionValue<E>(this.getKey(), functionTable);
    }

    @Override
    public ImmutableWeightedCollectionValue<E> withAll(Iterable<TableEntry<E>> elements) {
        Collection newTable = this.getAll();
        elements.forEach(((WeightedTable)newTable)::add);
        return new ImmutableSpongeWeightedCollectionValue<E>(this.getKey(), newTable);
    }

    @Override
    public ImmutableWeightedCollectionValue<E> without(TableEntry<E> element) {
        WeightedTable newTable = ((WeightedTable)this.actualValue).stream().filter(entry -> !entry.equals(element)).map(entry -> element).collect(Collectors.toCollection(WeightedTable::new));
        return new ImmutableSpongeWeightedCollectionValue<E>(this.getKey(), newTable);
    }

    @Override
    public ImmutableWeightedCollectionValue<E> withoutAll(Iterable<TableEntry<E>> elements) {
        WeightedTable newTable = new WeightedTable();
        ((WeightedTable)this.actualValue).stream().filter(entry -> !Iterables.contains((Iterable)elements, (Object)entry)).forEach(newTable::add);
        return new ImmutableSpongeWeightedCollectionValue(this.getKey(), newTable);
    }

    @Override
    public ImmutableWeightedCollectionValue<E> withoutAll(Predicate<TableEntry<E>> predicate) {
        WeightedTable newTable = ((WeightedTable)this.actualValue).stream().filter(predicate).collect(Collectors.toCollection(WeightedTable::new));
        return new ImmutableSpongeWeightedCollectionValue<E>(this.getKey(), newTable);
    }

    @Override
    public WeightedTable<E> getAll() {
        WeightedTable newTable = new WeightedTable();
        newTable.addAll((Collection)this.actualValue);
        return newTable;
    }

    @Override
    public WeightedCollectionValue<E> asMutable() {
        return new SpongeWeightedCollectionValue(this.getKey(), this.getAll());
    }

    @Override
    @Nullable
    public List<E> get(Random random) {
        return ((WeightedTable)this.actualValue).get(random);
    }
}

