/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.mutable;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableCollectionValue;
import org.spongepowered.api.data.value.mutable.CollectionValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public abstract class SpongeCollectionValue<Element, CollectionType extends Collection<Element>, CollectionValueType extends CollectionValue<Element, CollectionType, CollectionValueType, ImmutableType>, ImmutableType extends ImmutableCollectionValue<Element, CollectionType, ImmutableType, CollectionValueType>>
extends SpongeValue<CollectionType>
implements CollectionValue<Element, CollectionType, CollectionValueType, ImmutableType> {
    public SpongeCollectionValue(Key<? extends BaseValue<CollectionType>> key, CollectionType defaultValue) {
        super(key, defaultValue);
    }

    public SpongeCollectionValue(Key<? extends BaseValue<CollectionType>> key, CollectionType defaultValue, CollectionType actualValue) {
        super(key, defaultValue, actualValue);
    }

    @Override
    public CollectionValueType set(CollectionType value) {
        this.actualValue = Preconditions.checkNotNull(value);
        return (CollectionValueType)this;
    }

    @Override
    public CollectionValueType transform(Function<CollectionType, CollectionType> function) {
        this.actualValue = ((Function)Preconditions.checkNotNull(function)).apply(this.actualValue);
        return (CollectionValueType)this;
    }

    @Override
    public int size() {
        return ((Collection)this.actualValue).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Collection)this.actualValue).isEmpty();
    }

    @Override
    public CollectionValueType add(Element element) {
        ((Collection)this.actualValue).add(Preconditions.checkNotNull(element));
        return (CollectionValueType)this;
    }

    @Override
    public CollectionValueType addAll(Iterable<Element> elements) {
        for (Object element : (Iterable)Preconditions.checkNotNull(elements)) {
            ((Collection)this.actualValue).add(Preconditions.checkNotNull(element));
        }
        return (CollectionValueType)this;
    }

    @Override
    public CollectionValueType remove(Element element) {
        ((Collection)this.actualValue).remove(Preconditions.checkNotNull(element));
        return (CollectionValueType)this;
    }

    @Override
    public CollectionValueType removeAll(Iterable<Element> elements) {
        for (Element element : elements) {
            ((Collection)this.actualValue).remove(Preconditions.checkNotNull(element));
        }
        return (CollectionValueType)this;
    }

    @Override
    public CollectionValueType removeAll(Predicate<Element> predicate) {
        Iterator iterator = ((Collection)this.actualValue).iterator();
        while (iterator.hasNext()) {
            if (!((Predicate)Preconditions.checkNotNull(predicate)).test(iterator.next())) continue;
            iterator.remove();
        }
        return (CollectionValueType)this;
    }

    @Override
    public boolean contains(Element element) {
        return ((Collection)this.actualValue).contains(Preconditions.checkNotNull(element));
    }

    @Override
    public boolean containsAll(Collection<Element> iterable) {
        return ((Collection)this.actualValue).containsAll(iterable);
    }

    @Override
    public boolean exists() {
        return this.actualValue != null;
    }

    @Override
    public abstract ImmutableType asImmutable();

    @Override
    public abstract CollectionValueType copy();

    @Override
    public Optional<CollectionType> getDirect() {
        return Optional.of(this.actualValue);
    }

    @Override
    public Iterator<Element> iterator() {
        return ((Collection)this.actualValue).iterator();
    }
}

