/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context;

import com.google.common.base.MoreObjects;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.MultiBlockCaptureSupplier;
import org.spongepowered.common.event.tracking.context.SpongeProxyBlockAccess;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public abstract class BlockTransaction {
    final int transactionIndex;
    final int snapshotIndex;
    boolean isCancelled = false;
    boolean appliedPreChange;
    final BlockPos affectedPosition;
    final IBlockState originalState;
    @Nullable
    Map<BlockPos, TileEntity> tilesAtTransaction;
    @Nullable
    Map<BlockPos, IBlockState> blocksNotAffected;
    @Nullable
    BlockTransaction previous;
    @Nullable
    BlockTransaction next;

    BlockTransaction(int i, int snapshotIndex, BlockPos affectedPosition, IBlockState originalState) {
        this.transactionIndex = i;
        this.snapshotIndex = snapshotIndex;
        this.affectedPosition = affectedPosition;
        this.originalState = originalState;
        this.provideExistingBlockState(this, originalState);
        this.appliedPreChange = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    abstract Optional<WorldServerBridge> getWorldServer();

    abstract void cancel(WorldServer var1, BlockPos var2, SpongeProxyBlockAccess var3);

    abstract void process(Transaction<BlockSnapshot> var1, IPhaseState var2, PhaseContext<?> var3, int var4);

    boolean applyTileAtTransaction(BlockPos affectedPosition, TileEntity queuedRemoval) {
        if (this.tilesAtTransaction == null) {
            this.tilesAtTransaction = new LinkedHashMap<BlockPos, TileEntity>();
        }
        if (!this.tilesAtTransaction.containsKey(affectedPosition)) {
            this.tilesAtTransaction.put(affectedPosition, queuedRemoval);
            return true;
        }
        return false;
    }

    void provideExistingBlockState(BlockTransaction prevChange, IBlockState newState) {
        IBlockState iBlockState;
        if (newState == null) {
            return;
        }
        if (prevChange.affectedPosition.equals((Object)this.affectedPosition)) {
            return;
        }
        if (prevChange.blocksNotAffected == null) {
            prevChange.blocksNotAffected = new LinkedHashMap<BlockPos, IBlockState>();
        }
        if ((iBlockState = prevChange.blocksNotAffected.putIfAbsent(this.affectedPosition, newState)) == null) {
            this.appliedPreChange = true;
        }
    }

    public void enqueueChanges(SpongeProxyBlockAccess proxyBlockAccess, MultiBlockCaptureSupplier supplier) {
        supplier.getProxyOrCreate(proxyBlockAccess.getWorld());
        supplier.queuePreviousStates(this);
    }

    @Nullable
    public SpongeProxyBlockAccess.Proxy getProxy(WorldServerBridge mixinWorldServer) {
        return null;
    }

    public void provideUnchangedStates(BlockTransaction prevChange) {
    }

    public abstract void addToPrinter(PrettyPrinter var1);

    public void postProcessBlocksAffected(SpongeProxyBlockAccess proxyAccess) {
    }

    public boolean equalsSnapshot(SpongeBlockSnapshot snapshot) {
        return false;
    }

    public boolean acceptChunkChange(BlockPos pos, IBlockState newState) {
        return this.blocksNotAffected != null && !this.blocksNotAffected.isEmpty() && !this.affectedPosition.equals((Object)pos);
    }

    static final class TransactionContext
    extends PhaseContext<TransactionContext> {
        protected TransactionContext() {
            super(TransactionProcessState.TRANSACTION_PROCESS);
        }
    }

    static final class TransactionProcessState
    implements IPhaseState<TransactionContext> {
        public static final TransactionProcessState TRANSACTION_PROCESS = new TransactionProcessState();

        private TransactionProcessState() {
        }

        @Override
        public TransactionContext createPhaseContext() {
            throw new IllegalStateException("Cannot create context");
        }

        @Override
        public void unwind(TransactionContext phaseContext) {
        }

        @Override
        public boolean tracksOwnersAndNotifiers() {
            return false;
        }

        @Override
        public boolean isRestoring() {
            return true;
        }

        @Override
        public boolean doesBulkBlockCapture(TransactionContext context) {
            return false;
        }

        @Override
        public boolean doesBlockEventTracking(TransactionContext context) {
            return false;
        }

        @Override
        public boolean shouldCaptureBlockChangeOrSkip(TransactionContext phaseContext, BlockPos pos, IBlockState currentState, IBlockState newState, BlockChangeFlag flags) {
            return false;
        }
    }

    static final class NeighborNotification
    extends BlockTransaction {
        final WorldServerBridge worldServer;
        final IBlockState notifyState;
        final BlockPos notifyPos;
        final Block sourceBlock;
        final BlockPos sourcePos;

        NeighborNotification(int transactionIndex, int snapshotIndex, WorldServerBridge worldServer, IBlockState notifyState, BlockPos notifyPos, Block sourceBlock, BlockPos sourcePos, IBlockState sourceState) {
            super(transactionIndex, snapshotIndex, sourcePos, sourceState);
            this.worldServer = worldServer;
            this.notifyState = notifyState;
            this.notifyPos = notifyPos;
            this.sourceBlock = sourceBlock;
            this.sourcePos = sourcePos;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("worldServer", (Object)((org.spongepowered.api.world.World)((Object)this.worldServer)).getProperties().getWorldName()).add("notifyState", (Object)this.notifyState).add("notifyPos", (Object)this.notifyPos).add("sourceBlock", (Object)this.sourceBlock).add("sourcePos", (Object)this.sourcePos).add("actualSourceState", (Object)this.originalState).toString();
        }

        @Override
        public void provideUnchangedStates(BlockTransaction prevChange) {
            this.provideExistingBlockState(prevChange, this.originalState);
        }

        @Override
        public void enqueueChanges(SpongeProxyBlockAccess proxyBlockAccess, MultiBlockCaptureSupplier supplier) {
            super.enqueueChanges(proxyBlockAccess, supplier);
        }

        @Override
        void cancel(WorldServer worldServer, BlockPos blockPos, SpongeProxyBlockAccess proxyBlockAccess) {
        }

        @Override
        void process(Transaction<BlockSnapshot> eventTransaction, IPhaseState phaseState, PhaseContext<?> phaseContext, int currentDepth) {
            WorldServerBridge worldServer = this.worldServer;
            BlockPos notifyPos = this.notifyPos;
            Block sourceBlock = this.sourceBlock;
            BlockPos sourcePos = this.sourcePos;
            SpongeProxyBlockAccess proxyAccess = worldServer.bridge$getProxyAccess();
            IBlockState blockState = proxyAccess.func_180495_p(notifyPos);
            if (blockState == null) {
                blockState = ((WorldServer)this.worldServer).func_180495_p(notifyPos);
            }
            Chunk chunk = ((WorldServer)this.worldServer).func_175726_f(sourcePos);
            Block used = PhaseTracker.validateBlockForNeighborNotification((WorldServer)this.worldServer, sourcePos, sourceBlock, notifyPos, chunk);
            PhaseTracker.getInstance().notifyBlockOfStateChange(worldServer, blockState, notifyPos, used, sourcePos);
        }

        @Override
        boolean applyTileAtTransaction(BlockPos affectedPosition, TileEntity queuedRemoval) {
            if (this.tilesAtTransaction == null) {
                this.tilesAtTransaction = new LinkedHashMap();
            }
            if (!this.tilesAtTransaction.containsKey(affectedPosition)) {
                this.tilesAtTransaction.put(affectedPosition, queuedRemoval);
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptChunkChange(BlockPos pos, IBlockState newState) {
            if (this.blocksNotAffected == null) {
                this.blocksNotAffected = new LinkedHashMap();
            }
            return true;
        }

        @Override
        public void addToPrinter(PrettyPrinter printer) {
            printer.add("NeighborNotification").add(" %s : %s, %s", "Source Pos", this.originalState, this.sourcePos).add(" %s : %s, %s", "Notification", this.notifyState, this.notifyPos);
        }

        @Override
        Optional<WorldServerBridge> getWorldServer() {
            return Optional.of(this.worldServer);
        }
    }

    public static final class ChangeBlock
    extends BlockTransaction {
        final SpongeBlockSnapshot original;
        final IBlockState newState;
        final SpongeBlockChangeFlag blockChangeFlag;
        @Nullable
        public TileEntity queuedRemoval;
        @Nullable
        public TileEntity queueTileSet;
        boolean ignoreBreakBlockLogic = false;
        public boolean queueBreak = false;
        public boolean queueOnAdd = false;

        ChangeBlock(int i, int snapshotIndex, SpongeBlockSnapshot attachedSnapshot, IBlockState newState, SpongeBlockChangeFlag blockChange) {
            super(i, snapshotIndex, attachedSnapshot.getBlockPos(), (IBlockState)attachedSnapshot.getState());
            this.original = attachedSnapshot;
            this.newState = newState;
            this.blockChangeFlag = blockChange;
        }

        @Override
        void cancel(WorldServer worldServer, BlockPos blockPos, SpongeProxyBlockAccess proxyBlockAccess) {
        }

        @Override
        public void enqueueChanges(SpongeProxyBlockAccess proxyBlockAccess, MultiBlockCaptureSupplier supplier) {
            super.enqueueChanges(proxyBlockAccess, supplier);
            BlockPos target = this.original.getBlockPos();
            proxyBlockAccess.proceed(target, this.newState, false);
            if (this.queuedRemoval != null) {
                if (this.queueTileSet != null) {
                    this.queueTileSet.func_174878_a(target);
                    proxyBlockAccess.queueReplacement(this.queueTileSet, this.queuedRemoval);
                } else {
                    proxyBlockAccess.queueRemoval(this.queuedRemoval);
                }
            } else if (this.queueTileSet != null) {
                proxyBlockAccess.queueTileAddition(target, this.queueTileSet);
            }
        }

        @Override
        void process(Transaction<BlockSnapshot> eventTransaction, IPhaseState phaseState, PhaseContext<?> phaseContext, int currentDepth) {
            BlockPos targetPosition = this.original.getBlockPos();
            Optional<WorldServer> maybeWorld = this.original.getWorldServer();
            if (!maybeWorld.isPresent()) {
                String transactionForLogging = MoreObjects.toStringHelper((String)"Transaction").add("World", (Object)this.original.getWorldUniqueId()).add("Position", (Object)this.original.getBlockPos()).add("Original State", (Object)this.original.getState()).add("Changed State", (Object)this.newState).toString();
                SpongeImpl.getLogger().warn("Unloaded/Missing World for a captured block change! Skipping change: " + transactionForLogging);
                return;
            }
            WorldServer worldServer = maybeWorld.get();
            SpongeBlockSnapshot newBlockSnapshot = (SpongeBlockSnapshot)eventTransaction.getFinal();
            TrackingUtil.performBlockEntitySpawns(phaseState, phaseContext, this.original, targetPosition);
            SpongeHooks.logBlockAction((World)worldServer, this.original.blockChange, eventTransaction);
            IBlockState oldState = (IBlockState)this.original.getState();
            SpongeProxyBlockAccess proxyAccess = ((WorldServerBridge)worldServer).bridge$getProxyAccess();
            PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
            try (TransactionContext context = new TransactionContext();){
                context.buildAndSwitch();
                proxyAccess.proceed(targetPosition, this.newState, true);
            }
            if (this.queuedRemoval != null) {
                proxyAccess.proceedWithRemoval(targetPosition, this.queuedRemoval);
            }
            if (this.queueOnAdd) {
                this.newState.func_177230_c().func_176213_c((World)worldServer, targetPosition, this.newState);
                phaseState.performOnBlockAddedSpawns(phaseContext, currentDepth + 1);
            }
            if (this.queueTileSet != null) {
                proxyAccess.proceedWithAdd(targetPosition, this.queueTileSet);
            }
            phaseState.postBlockTransactionApplication(this.original.blockChange, eventTransaction, phaseContext);
            currentContext.state.postProcessSpecificBlockChange(currentContext, this, currentDepth + 1);
            if (this.blockChangeFlag.isNotifyClients()) {
                worldServer.func_184138_a(targetPosition, oldState, this.newState, this.blockChangeFlag.getRawFlag());
            }
            TrackingUtil.performNeighborAndClientNotifications(phaseContext, currentDepth, newBlockSnapshot, (WorldServerBridge)worldServer, targetPosition, this.newState, this.blockChangeFlag);
            TrackingUtil.performBlockEntitySpawns(phaseState, phaseContext, this.original, targetPosition);
        }

        @Override
        public void provideUnchangedStates(BlockTransaction prevChange) {
            this.provideExistingBlockState(prevChange, (IBlockState)this.original.getState());
            if (prevChange.applyTileAtTransaction(this.affectedPosition, this.queuedRemoval)) {
                this.appliedPreChange = true;
            }
        }

        @Override
        @Nullable
        public SpongeProxyBlockAccess.Proxy getProxy(WorldServerBridge mixinWorldServer) {
            return mixinWorldServer.bridge$getProxyAccess().pushProxy();
        }

        @Override
        Optional<WorldServerBridge> getWorldServer() {
            return this.original.getWorldServer();
        }

        @Override
        public void addToPrinter(PrettyPrinter printer) {
            printer.add("ChangeBlock").add(" %s : %s", "Original Block", this.original).add(" %s : %s", "New State", this.newState).add(" %s : %s", "RemovedTile", this.queuedRemoval).add(" %s : %s", "AddedTile", this.queueTileSet).add(" %s : %s", "ChangeFlag", this.blockChangeFlag);
        }

        @Override
        public boolean equalsSnapshot(SpongeBlockSnapshot snapshot) {
            return this.original.equals(snapshot);
        }
    }

    public static final class ReplaceTileEntity
    extends BlockTransaction {
        final TileEntity added;
        final TileEntity removed;
        final SpongeBlockSnapshot removedSnapshot;

        ReplaceTileEntity(int i, int snapshotIndex, TileEntity added, TileEntity removed, SpongeBlockSnapshot attachedSnapshot) {
            super(i, snapshotIndex, attachedSnapshot.getBlockPos(), null);
            this.added = added;
            this.removed = removed;
            this.removedSnapshot = attachedSnapshot;
            this.applyTileAtTransaction(this.affectedPosition, this.removed);
            this.appliedPreChange = false;
        }

        @Override
        void cancel(WorldServer worldServer, BlockPos blockPos, SpongeProxyBlockAccess proxyBlockAccess) {
            proxyBlockAccess.unQueueTileAddition(this.removed.func_174877_v(), this.added);
            proxyBlockAccess.unmarkRemoval(this.removed.func_174877_v(), this.removed);
        }

        @Override
        void process(Transaction<BlockSnapshot> eventTransaction, IPhaseState phaseState, PhaseContext<?> phaseContext, int currentDepth) {
            WorldServerBridge mixinWorldServer = (WorldServerBridge)this.added.func_145831_w();
            BlockPos position = this.added.func_174877_v();
            SpongeProxyBlockAccess proxyAccess = mixinWorldServer.bridge$getProxyAccess();
            ((TileEntityBridge)this.removed).bridge$setCaptured(false);
            proxyAccess.proceedWithRemoval(position, this.removed);
            ((TileEntityBridge)this.added).bridge$setCaptured(false);
            proxyAccess.proceedWithAdd(position, this.added);
        }

        @Override
        public void provideUnchangedStates(BlockTransaction prevChange) {
            if (prevChange.applyTileAtTransaction(this.affectedPosition, this.removed)) {
                this.appliedPreChange = true;
            }
        }

        @Override
        public void enqueueChanges(SpongeProxyBlockAccess proxyBlockAccess, MultiBlockCaptureSupplier supplier) {
            super.enqueueChanges(proxyBlockAccess, supplier);
            proxyBlockAccess.queueReplacement(this.added, this.removed);
        }

        @Override
        @Nullable
        public SpongeProxyBlockAccess.Proxy getProxy(WorldServerBridge mixinWorldServer) {
            return mixinWorldServer.bridge$getProxyAccess().pushProxy();
        }

        @Override
        Optional<WorldServerBridge> getWorldServer() {
            return this.removedSnapshot.getWorldServer();
        }

        @Override
        public void addToPrinter(PrettyPrinter printer) {
            printer.add("ReplaceTileEntity").add(" %s : %s", "Position", this.affectedPosition).add(" %s : %s", "Added", this.added).add(" %s : %s", "Removed", this.removed);
        }
    }

    public static final class RemoveTileEntity
    extends BlockTransaction {
        final TileEntity removed;
        final SpongeBlockSnapshot tileSnapshot;

        RemoveTileEntity(int i, int snapshotIndex, TileEntity removed, SpongeBlockSnapshot attachedSnapshot) {
            super(i, snapshotIndex, attachedSnapshot.getBlockPos(), null);
            this.removed = removed;
            this.tileSnapshot = attachedSnapshot;
            this.applyTileAtTransaction(this.affectedPosition, this.removed);
            this.appliedPreChange = false;
        }

        @Override
        void cancel(WorldServer worldServer, BlockPos blockPos, SpongeProxyBlockAccess proxyBlockAccess) {
            proxyBlockAccess.unmarkRemoval(this.removed.func_174877_v(), this.removed);
        }

        @Override
        void process(Transaction<BlockSnapshot> eventTransaction, IPhaseState phaseState, PhaseContext<?> phaseContext, int currentDepth) {
            BlockPos targetPosition = this.tileSnapshot.getBlockPos();
            Optional<WorldServer> maybeWorld = this.tileSnapshot.getWorldServer();
            if (!maybeWorld.isPresent()) {
                String transactionForLogging = MoreObjects.toStringHelper((String)"Tile Removed").add("World", (Object)this.tileSnapshot.getWorldUniqueId()).add("Position", (Object)this.tileSnapshot.getBlockPos()).add("Original State", (Object)this.tileSnapshot.getState()).add("Tile Entity", (Object)this.removed).toString();
                SpongeImpl.getLogger().warn("Unloaded/Missing World for a captured Tile Entity removal! Skipping change: " + transactionForLogging);
                this.removed.func_145834_a(null);
                this.removed.func_145843_s();
                return;
            }
            WorldServer worldServer = maybeWorld.get();
            SpongeProxyBlockAccess proxyAccess = ((WorldServerBridge)worldServer).bridge$getProxyAccess();
            ((TileEntityBridge)this.removed).bridge$setCaptured(false);
            proxyAccess.proceedWithRemoval(targetPosition, this.removed);
            worldServer.func_175666_e(targetPosition, worldServer.func_180495_p(targetPosition).func_177230_c());
        }

        @Override
        public void addToPrinter(PrettyPrinter printer) {
            printer.add("RemoveTileEntity").add(" %s : %s", this.affectedPosition, ((TileEntityBridge)this.removed).bridge$getPrettyPrinterString()).add(" %s : %s", this.affectedPosition, this.originalState);
        }

        @Override
        public void provideUnchangedStates(BlockTransaction prevChange) {
            if (prevChange.applyTileAtTransaction(this.affectedPosition, this.removed)) {
                this.appliedPreChange = true;
            }
        }

        @Override
        public void enqueueChanges(SpongeProxyBlockAccess proxyBlockAccess, MultiBlockCaptureSupplier supplier) {
            super.enqueueChanges(proxyBlockAccess, supplier);
            proxyBlockAccess.queueRemoval(this.removed);
        }

        @Override
        @Nullable
        public SpongeProxyBlockAccess.Proxy getProxy(WorldServerBridge mixinWorldServer) {
            return mixinWorldServer.bridge$getProxyAccess().pushProxy();
        }

        @Override
        Optional<WorldServerBridge> getWorldServer() {
            return this.tileSnapshot.getWorldServer();
        }
    }

    public static final class AddTileEntity
    extends BlockTransaction {
        final TileEntity added;
        final SpongeBlockSnapshot addedSnapshot;

        AddTileEntity(int i, int snapshotIndex, TileEntity added, SpongeBlockSnapshot attachedSnapshot) {
            super(i, snapshotIndex, attachedSnapshot.getBlockPos(), null);
            this.added = added;
            this.addedSnapshot = attachedSnapshot;
        }

        @Override
        void cancel(WorldServer worldServer, BlockPos blockPos, SpongeProxyBlockAccess proxyBlockAccess) {
            proxyBlockAccess.unQueueTileAddition(this.added.func_174877_v(), this.added);
        }

        @Override
        void process(Transaction<BlockSnapshot> eventTransaction, IPhaseState phaseState, PhaseContext<?> phaseContext, int currentDepth) {
            Optional<WorldServer> maybeWorld = this.addedSnapshot.getWorldServer();
            if (!maybeWorld.isPresent()) {
                String transactionForLogging = MoreObjects.toStringHelper((String)"Tile Added").add("World", (Object)this.addedSnapshot.getWorldUniqueId()).add("Position", (Object)this.addedSnapshot.getBlockPos()).add("Original State", (Object)this.addedSnapshot.getState()).add("Tile Entity", (Object)this.added).toString();
                SpongeImpl.getLogger().warn("Unloaded/Missing World for a captured Tile Entity adding! Skipping change: " + transactionForLogging);
                this.added.func_145834_a(null);
                this.added.func_145843_s();
                return;
            }
            WorldServer worldServer = maybeWorld.get();
            SpongeProxyBlockAccess proxyAccess = ((WorldServerBridge)worldServer).bridge$getProxyAccess();
            BlockPos targetPos = this.addedSnapshot.getBlockPos();
            proxyAccess.proceedWithAdd(targetPos, this.added);
            ((TileEntityBridge)this.added).bridge$setCaptured(false);
        }

        @Override
        public void provideUnchangedStates(BlockTransaction prevChange) {
            if (prevChange.applyTileAtTransaction(this.affectedPosition, null)) {
                this.appliedPreChange = true;
            }
        }

        @Override
        public void enqueueChanges(SpongeProxyBlockAccess proxyBlockAccess, MultiBlockCaptureSupplier supplier) {
            super.enqueueChanges(proxyBlockAccess, supplier);
            proxyBlockAccess.queueTileAddition(this.addedSnapshot.getBlockPos(), this.added);
        }

        @Override
        @Nullable
        public SpongeProxyBlockAccess.Proxy getProxy(WorldServerBridge mixinWorldServer) {
            SpongeProxyBlockAccess proxyAccess = mixinWorldServer.bridge$getProxyAccess();
            return proxyAccess.pushProxy();
        }

        @Override
        Optional<WorldServerBridge> getWorldServer() {
            return this.addedSnapshot.getWorldServer();
        }

        @Override
        public void addToPrinter(PrettyPrinter printer) {
            printer.add("AddTileEntity").addWrapped(120, " %s : %s", this.affectedPosition, ((TileEntityBridge)this.added).bridge$getPrettyPrinterString());
        }
    }
}

