/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.gen.feature;

import com.flowpowered.math.vector.Vector3i;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBush;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Mushroom;
import org.spongepowered.api.world.gen.type.MushroomType;
import org.spongepowered.api.world.gen.type.MushroomTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={WorldGenBush.class})
public abstract class WorldGenBushMixin_API
extends WorldGenerator
implements Mushroom {
    @Shadow
    @Final
    @Mutable
    private BlockBush field_175908_a;
    @Nullable
    private Function<Location<Extent>, MushroomType> api$override = null;
    private final ChanceTable<MushroomType> api$types = new ChanceTable();
    private VariableAmount api$mushroomsPerChunk = VariableAmount.fixed(1.0);

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.MUSHROOM;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.api$mushroomsPerChunk.getFlooredAmount(random);
        MushroomType type = MushroomTypes.BROWN;
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            int y = this.nextInt(random, world.func_175645_m(chunkPos.func_177982_a(x, 0, z)).func_177956_o() * 2);
            BlockPos height = chunkPos.func_177982_a(x, y, z);
            if (this.api$override != null) {
                Location<Extent> pos2 = new Location<Extent>(extent, VecHelper.toVector3i(height));
                type = this.api$override.apply(pos2);
            } else {
                List<MushroomType> result = this.api$types.get(random);
                if (result.isEmpty()) continue;
                type = result.get(0);
            }
            this.field_175908_a = type == MushroomTypes.BROWN ? Blocks.field_150338_P : Blocks.field_150337_Q;
            this.func_180709_b(world, random, height);
        }
    }

    private int nextInt(Random rand, int i) {
        if (i <= 1) {
            return 0;
        }
        return rand.nextInt(i);
    }

    @Override
    public ChanceTable<MushroomType> getTypes() {
        return this.api$types;
    }

    @Override
    public VariableAmount getMushroomsPerChunk() {
        return this.api$mushroomsPerChunk;
    }

    @Override
    public void setMushroomsPerChunk(VariableAmount count) {
        this.api$mushroomsPerChunk = count;
    }

    @Override
    public Optional<Function<Location<Extent>, MushroomType>> getSupplierOverride() {
        return Optional.ofNullable(this.api$override);
    }

    @Override
    public void setSupplierOverride(@Nullable Function<Location<Extent>, MushroomType> override) {
        this.api$override = override;
    }
}

