/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ai.Goal;
import org.spongepowered.api.entity.ai.GoalTypes;
import org.spongepowered.api.entity.ai.task.AITask;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.LeashEntityEvent;
import org.spongepowered.api.event.entity.UnleashEntityEvent;
import org.spongepowered.api.event.entity.ai.AITaskEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.entity.GrieferBridge;
import org.spongepowered.common.bridge.entity.ai.EntityAIBasesBridge;
import org.spongepowered.common.bridge.entity.ai.EntityAITasksBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.EntityLivingBaseMixin;

@Mixin(value={EntityLiving.class})
public abstract class EntityLivingMixin
extends EntityLivingBaseMixin {
    @Shadow
    @Final
    protected EntityAITasks field_70714_bg;
    @Shadow
    @Final
    protected EntityAITasks field_70715_bh;
    @Shadow
    @Nullable
    private EntityLivingBase field_70696_bz;

    @Shadow
    public abstract boolean func_175446_cd();

    @Shadow
    @Nullable
    public abstract net.minecraft.entity.Entity func_110166_bE();

    @Shadow
    protected abstract void func_184651_r();

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLiving;initEntityAI()V"))
    private void spongeImpl$initializeAI(EntityLiving this$0) {
        this.initSpongeAI();
        this.func_184651_r();
    }

    private void initSpongeAI() {
        if (!((EntityAITasksBridge)this.field_70714_bg).bridge$initialized()) {
            ((EntityAITasksBridge)this.field_70714_bg).bridge$setOwner((EntityLiving)this);
            ((EntityAITasksBridge)this.field_70714_bg).bridge$setType(GoalTypes.NORMAL);
            ((EntityAITasksBridge)this.field_70714_bg).bridge$setInitialized(true);
        }
        if (!((EntityAITasksBridge)this.field_70715_bh).bridge$initialized()) {
            ((EntityAITasksBridge)this.field_70715_bh).bridge$setOwner((EntityLiving)this);
            ((EntityAITasksBridge)this.field_70715_bh).bridge$setType(GoalTypes.TARGET);
            ((EntityAITasksBridge)this.field_70715_bh).bridge$setInitialized(true);
        }
    }

    @Override
    public void bridge$fireConstructors() {
        super.bridge$fireConstructors();
        if (ShouldFire.A_I_TASK_EVENT_ADD) {
            this.handleDelayedTaskEventFiring((EntityAITasksBridge)this.field_70714_bg);
            this.handleDelayedTaskEventFiring((EntityAITasksBridge)this.field_70715_bh);
        }
    }

    private void handleDelayedTaskEventFiring(EntityAITasksBridge tasks) {
        Iterator<EntityAITasks.EntityAITaskEntry> taskItr = tasks.bridge$getTasksUnsafe().iterator();
        while (taskItr.hasNext()) {
            EntityAITasks.EntityAITaskEntry task = taskItr.next();
            AITaskEvent.Add event = SpongeEventFactory.createAITaskEventAdd(Sponge.getCauseStackManager().getCurrentCause(), task.field_75731_b, task.field_75731_b, (Goal)((Object)tasks), (Agent)((Object)this), (AITask)task.field_75733_a);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) continue;
            ((EntityAIBasesBridge)task.field_75733_a).bridge$setGoal(null);
            taskItr.remove();
        }
    }

    @Inject(method={"processInitialInteract"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLiving;setLeashHolder(Lnet/minecraft/entity/Entity;Z)V")})
    private void callLeashEvent(EntityPlayer playerIn, EnumHand hand, CallbackInfoReturnable<Boolean> ci) {
        if (!playerIn.field_70170_p.field_72995_K) {
            Sponge.getCauseStackManager().pushCause(playerIn);
            LeashEntityEvent event = SpongeEventFactory.createLeashEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), (Living)((Object)this));
            SpongeImpl.postEvent(event);
            Sponge.getCauseStackManager().popCause();
            if (event.isCancelled()) {
                ci.setReturnValue(false);
            }
        }
    }

    @Inject(method={"clearLeashed"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/EntityLiving;isLeashed:Z", opcode=181)}, cancellable=true)
    private void impl$ThrowUnleashEvent(boolean sendPacket, boolean dropLead, CallbackInfo ci) {
        net.minecraft.entity.Entity entity = this.func_110166_bE();
        if (!this.field_70170_p.field_72995_K) {
            CauseStackManager csm = Sponge.getCauseStackManager();
            if (entity == null) {
                csm.pushCause(this);
            } else {
                csm.pushCause(entity);
            }
            UnleashEntityEvent event = SpongeEventFactory.createUnleashEntityEvent(csm.getCurrentCause(), (Living)((Object)this));
            SpongeImpl.postEvent(event);
            csm.popCause();
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @ModifyConstant(method={"despawnEntity"}, constant={@Constant(doubleValue=16384.0)})
    private double getHardDespawnRange(double value) {
        if (!this.field_70170_p.field_72995_K) {
            return Math.pow(((WorldInfoBridge)this.field_70170_p.func_72912_H()).bridge$getConfigAdapter().getConfig().getEntity().getHardDespawnRange(), 2.0);
        }
        return value;
    }

    @ModifyConstant(method={"despawnEntity"}, constant={@Constant(doubleValue=1024.0)}, expect=2)
    private double getSoftDespawnRange(double value) {
        if (!this.field_70170_p.field_72995_K) {
            return Math.pow(((WorldInfoBridge)this.field_70170_p.func_72912_H()).bridge$getConfigAdapter().getConfig().getEntity().getSoftDespawnRange(), 2.0);
        }
        return value;
    }

    @ModifyConstant(method={"despawnEntity"}, constant={@Constant(intValue=600)})
    private int getMinimumLifetime(int value) {
        if (!this.field_70170_p.field_72995_K) {
            return ((WorldInfoBridge)this.field_70170_p.func_72912_H()).bridge$getConfigAdapter().getConfig().getEntity().getMinimumLife() * 20;
        }
        return value;
    }

    @Nullable
    @Redirect(method={"despawnEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getClosestPlayerToEntity(Lnet/minecraft/entity/Entity;D)Lnet/minecraft/entity/player/EntityPlayer;"))
    private EntityPlayer impl$getClosestPlayerForSpawning(World world, net.minecraft.entity.Entity entity, double distance) {
        double bestDistance = -1.0;
        EntityPlayer result = null;
        for (Object entity1 : world.field_73010_i) {
            EntityPlayer player = (EntityPlayer)entity1;
            if (player == null || player.field_70128_L || !((EntityPlayerBridge)player).bridge$affectsSpawning()) continue;
            double playerDistance = player.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(distance < 0.0) && !(playerDistance < distance * distance) || bestDistance != -1.0 && !(playerDistance < bestDistance)) continue;
            bestDistance = playerDistance;
            result = player;
        }
        return result;
    }

    @Inject(method={"setAttackTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetAttackTarget(@Nullable EntityLivingBase entitylivingbaseIn, CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K || entitylivingbaseIn == null) {
            return;
        }
        if (EntityUtil.isUntargetable((net.minecraft.entity.Entity)this, (net.minecraft.entity.Entity)entitylivingbaseIn)) {
            this.field_70696_bz = null;
            ci.cancel();
            return;
        }
        if (ShouldFire.SET_A_I_TARGET_EVENT) {
            SetAITargetEvent event = SpongeCommonEventFactory.callSetAttackTargetEvent((Entity)entitylivingbaseIn, (Agent)((Object)this));
            if (event.isCancelled()) {
                ci.cancel();
            } else {
                this.field_70696_bz = event.getTarget().orElse(null);
            }
        }
    }

    @Nullable
    @Overwrite
    public EntityLivingBase func_70638_az() {
        if (this.field_70696_bz != null && EntityUtil.isUntargetable((net.minecraft.entity.Entity)this, (net.minecraft.entity.Entity)this.field_70696_bz)) {
            this.field_70696_bz = null;
        }
        return this.field_70696_bz;
    }

    @Redirect(method={"onLivingUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLiving;canPickUpLoot()Z"))
    private boolean onCanGrief(EntityLiving thisEntity) {
        return thisEntity.func_98052_bS() && ((GrieferBridge)((Object)this)).bridge$CanGrief();
    }

    @Override
    public void bridge$onJoinWorld() {
        this.initSpongeAI();
    }
}

