/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.data.type.Professions;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.entity.SpongeCareer;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.entity.CareerRegistryModule;

public class ProfessionRegistryModule
implements AlternateCatalogRegistryModule<Profession>,
SpongeAdditionalCatalogRegistryModule<Profession> {
    public static final Profession FARMER = new SpongeProfession(0, "minecraft:farmer", "farmer");
    public static final Profession LIBRARIAN = new SpongeProfession(1, "minecraft:librarian", "librarian");
    public static final Profession PRIEST = new SpongeProfession(2, "minecraft:priest", "priest");
    public static final Profession BLACKSMITH = new SpongeProfession(3, "minecraft:blacksmith", "blacksmith");
    public static final Profession BUTCHER = new SpongeProfession(4, "minecraft:butcher", "butcher");
    public static final Profession NITWIT = new SpongeProfession(5, "minecraft:nitwit", "nitwit");
    @RegisterCatalog(value=Professions.class)
    private final Map<String, Profession> professionMap = new LinkedHashMap<String, Profession>();

    public static ProfessionRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(Profession extraCatalog) {
        String catalogId = extraCatalog.getId().toLowerCase(Locale.ENGLISH);
        if (catalogId.equals("smith")) {
            return;
        }
        if (!this.professionMap.containsKey(catalogId)) {
            this.professionMap.put(catalogId, extraCatalog);
        }
    }

    @Override
    public Optional<Profession> getById(String id) {
        return Optional.ofNullable(this.professionMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Profession> getAll() {
        return ImmutableList.copyOf(this.professionMap.values());
    }

    public void registerCareerForProfession(Career career) {
        SpongeProfession profession = (SpongeProfession)((Career)Preconditions.checkNotNull((Object)career)).getProfession();
        List<Career> careers = profession.getUnderlyingCareers();
        boolean isRegistered = false;
        SpongeCareer spongeCareer = (SpongeCareer)career;
        for (SpongeCareer spongeCareer2 : careers) {
            if (spongeCareer.type != spongeCareer2.type) continue;
            isRegistered = true;
        }
        if (!isRegistered && !careers.contains(spongeCareer)) {
            careers.add(spongeCareer);
            Collections.sort(careers, CareerRegistryModule.CAREER_COMPARATOR);
        }
    }

    @Override
    public void registerDefaults() {
        this.professionMap.put("minecraft:farmer", FARMER);
        this.professionMap.put("minecraft:librarian", LIBRARIAN);
        this.professionMap.put("minecraft:priest", PRIEST);
        this.professionMap.put("minecraft:blacksmith", BLACKSMITH);
        this.professionMap.put("minecraft:butcher", BUTCHER);
        this.professionMap.put("minecraft:nitwit", NITWIT);
    }

    ProfessionRegistryModule() {
    }

    @Override
    public Map<String, Profession> provideCatalogMap() {
        HashMap<String, Profession> map = new HashMap<String, Profession>();
        for (Map.Entry<String, Profession> entry : this.professionMap.entrySet()) {
            map.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return map;
    }

    private static final class Holder {
        static final ProfessionRegistryModule INSTANCE = new ProfessionRegistryModule();

        private Holder() {
        }
    }
}

