/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.scheduler.ScheduledTask;
import org.spongepowered.common.scheduler.SchedulerBase;

public class SyncScheduler
extends SchedulerBase {
    private volatile long counter = 0L;

    SyncScheduler() {
        super(ScheduledTask.TaskSynchronicity.SYNCHRONOUS);
    }

    void tick() {
        ++this.counter;
        this.runTick();
    }

    @Override
    protected long getTimestamp(ScheduledTask task) {
        if (task.getState() == ScheduledTask.ScheduledTaskState.WAITING) {
            if (task.delayIsTicks) {
                return this.counter;
            }
            return super.getTimestamp(task);
        }
        if (task.getState().isActive) {
            if (task.intervalIsTicks) {
                return this.counter;
            }
            return super.getTimestamp(task);
        }
        return 0L;
    }

    @Override
    protected void executeTaskRunnable(ScheduledTask task, Runnable runnable) {
        try (BasicPluginContext context = this.createContext(task);){
            if (context != null) {
                context.buildAndSwitch();
            }
            runnable.run();
        }
    }

    @Nullable
    private BasicPluginContext createContext(ScheduledTask task) {
        return Sponge.isServerAvailable() ? (BasicPluginContext)PluginPhase.State.SCHEDULED_TASK.createPhaseContext().source(task) : null;
    }
}

