/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.graph;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DirectedGraph<D> {
    private final Map<D, DataNode<D>> nodes = new HashMap<D, DataNode<D>>();

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getEdgeCount() {
        int count = 0;
        for (DataNode<D> n : this.nodes.values()) {
            count += n.getEdgeCount();
        }
        return count;
    }

    public boolean contains(D data) {
        return this.nodes.containsKey(data);
    }

    public DataNode<D> get(D data) {
        return this.nodes.get(data);
    }

    public void addEdge(D from, D to) {
        DataNode<D> toNode;
        DataNode<D> fromNode = this.add(from);
        if (!fromNode.isAdjacent(toNode = this.add(to))) {
            fromNode.addEdge(toNode);
        }
    }

    public Collection<DataNode<D>> getNodes() {
        return this.nodes.values();
    }

    public DirectedGraph<D> reverse() {
        DirectedGraph<D> rev = new DirectedGraph<D>();
        HashMap<DataNode<D>, DataNode<D>> siblings = new HashMap<DataNode<D>, DataNode<D>>();
        for (DataNode<D> n : this.nodes.values()) {
            DataNode<D> b = rev.add(n.getData());
            siblings.put(n, b);
        }
        for (DataNode<D> n : this.nodes.values()) {
            DataNode n_sibling = (DataNode)siblings.get(n);
            for (DataNode<D> b : n.getAdjacent()) {
                ((DataNode)siblings.get(b)).addEdge(n_sibling);
            }
        }
        return rev;
    }

    public DataNode<D> add(D d) {
        DataNode<D> node = this.nodes.get(d);
        if (node == null) {
            node = new DataNode<D>(d);
            this.nodes.put(d, node);
        }
        return node;
    }

    public boolean remove(D n) {
        DataNode<D> node = this.nodes.get(n);
        if (node == null) {
            return false;
        }
        for (DataNode<D> b : this.nodes.values()) {
            b.removeEdge(node);
        }
        this.nodes.remove(n);
        return true;
    }

    public void clear() {
        this.nodes.clear();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Node count: ").append(this.getNodeCount());
        str.append(" Edge count: ").append(this.getEdgeCount()).append("\n");
        for (DataNode<D> n : this.nodes.values()) {
            str.append(n.getData().toString()).append(" Edges: (");
            for (DataNode<D> a : n.getAdjacent()) {
                str.append(a.getData().toString()).append(" ");
            }
            str.append(")\n");
        }
        return str.toString();
    }

    public static class DataNode<D> {
        private final List<DataNode<D>> adj = Lists.newArrayList();
        final D data;

        public DataNode(D obj) {
            this.data = obj;
        }

        public D getData() {
            return this.data;
        }

        public void addEdge(DataNode<D> other) {
            this.adj.add(other);
        }

        public boolean removeEdge(DataNode<D> other) {
            return this.adj.remove(other);
        }

        public boolean isAdjacent(DataNode<D> other) {
            return this.adj.contains(other);
        }

        public int getEdgeCount() {
            return this.adj.size();
        }

        public Collection<DataNode<D>> getAdjacent() {
            return this.adj;
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataNode)) {
                return false;
            }
            DataNode d = (DataNode)o;
            return d.getData().equals(this.data);
        }
    }
}

