/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.item.merchant.Merchant;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.entity.EntityVillagerBridge;
import org.spongepowered.common.entity.SpongeCareer;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.registry.SpongeVillagerRegistry;
import org.spongepowered.common.registry.type.entity.CareerRegistryModule;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.text.translation.SpongeTranslation;
import org.spongepowered.mod.bridge.entity.passive.EntityVillagerBridge_Forge;
import org.spongepowered.mod.bridge.registry.VillagerCareerBridge_Forge;
import org.spongepowered.mod.bridge.registry.VillagerProfessionBridge_Forge;

public final class SpongeForgeVillagerRegistry {
    private static final BiMap<String, Profession> ALIASED_PROFESSION_BIMAP = HashBiMap.create();
    private static final BiMap<String, Career> ALIASED_CAREER_MAP = HashBiMap.create();

    @Nonnull
    public static SpongeProfession fromNative(VillagerRegistry.VillagerProfession profession) {
        VillagerProfessionBridge_Forge mixinProfession = (VillagerProfessionBridge_Forge)profession;
        return mixinProfession.forgeBridge$getSpongeProfession().orElseGet(() -> {
            int id = ((ForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS).getID((IForgeRegistryEntry)profession);
            SpongeProfession newProfession = new SpongeProfession(id, mixinProfession.forgeBridge$getId(), mixinProfession.forgeBridge$getProfessionName());
            mixinProfession.forgeBridge$setSpongeProfession(newProfession);
            ProfessionRegistryModule.getInstance().registerAdditionalCatalog(newProfession);
            return newProfession;
        });
    }

    public static SpongeCareer fromNative(VillagerRegistry.VillagerCareer career) {
        VillagerCareerBridge_Forge mixinCareer = (VillagerCareerBridge_Forge)career;
        if (mixinCareer.forgeBridge$isDelayed() && SpongeImplHooks.isMainThread()) {
            mixinCareer.forgeBridge$performDelayedInit();
        }
        return mixinCareer.forgeBridge$getSpongeCareer().orElseGet(() -> {
            int careerId = mixinCareer.forgeBridge$getId();
            SpongeCareer suggestedCareer = new SpongeCareer(careerId, career.getName(), SpongeForgeVillagerRegistry.fromNative(mixinCareer.forgeBridge$getProfession()), new SpongeTranslation("entity.Villager." + career.getName()));
            mixinCareer.forgeBridge$setSpongeCareer(suggestedCareer);
            CareerRegistryModule.getInstance().registerCareer(suggestedCareer);
            ProfessionRegistryModule.getInstance().registerCareerForProfession(suggestedCareer);
            return suggestedCareer;
        });
    }

    public static void spongePopupateList(EntityVillagerBridge_Forge mixinEntityVillager, VillagerRegistry.VillagerProfession professionForge, int careerNumberId, int careerLevel, Random rand) {
        EntityVillagerBridge villagerBridge = (EntityVillagerBridge)((Object)mixinEntityVillager);
        if (!villagerBridge.bridge$getProfessionOptional().isPresent()) {
            villagerBridge.bridge$setProfession(SpongeForgeVillagerRegistry.fromNative(professionForge));
        }
        Profession profession = villagerBridge.bridge$getProfessionOptional().get();
        VillagerRegistry.VillagerCareer career = professionForge.getCareer(careerNumberId);
        List<Career> careers = ((SpongeProfession)profession).getUnderlyingCareers();
        if (careers.size() <= careerNumberId) {
            List<Career> underlyingCareers = ((SpongeProfession)profession).getUnderlyingCareers();
            underlyingCareers.clear();
            VillagerProfessionBridge_Forge mixinProfession = (VillagerProfessionBridge_Forge)professionForge;
            for (VillagerRegistry.VillagerCareer villagerCareer : mixinProfession.forgeBridge$getCareers()) {
                SpongeForgeVillagerRegistry.fromNative(villagerCareer);
            }
            if (careers.size() <= careerNumberId) {
                SpongeForgeVillagerRegistry.printMismatch(careerNumberId, profession, careers, mixinProfession);
                SpongeForgeVillagerRegistry.populateOffers(mixinEntityVillager, career, careerLevel, rand);
                return;
            }
        }
        SpongeCareer spongeCareer = (SpongeCareer)careers.get(careerNumberId);
        SpongeVillagerRegistry.getInstance().populateOffers((Merchant)((Object)mixinEntityVillager), (List<TradeOffer>)mixinEntityVillager.forgeBridge$getForgeTrades(), spongeCareer, careerLevel + 1, rand);
    }

    public static void populateOffers(EntityVillagerBridge_Forge mixinEntityVillager, VillagerRegistry.VillagerCareer career, int careerLevel, Random rand) {
        MerchantRecipeList villagerTrades = mixinEntityVillager.forgeBridge$getForgeTrades();
        List trades = career.getTrades(careerLevel);
        if (trades != null && !trades.isEmpty()) {
            for (EntityVillager.ITradeList entityvillager$itradelist : trades) {
                entityvillager$itradelist.func_190888_a((IMerchant)((EntityVillager)mixinEntityVillager), villagerTrades, rand);
            }
        }
    }

    private static void printDebuggingVillagerInfo(EntityVillagerBridge_Forge mixinEntityVillager, MerchantRecipeList temporary) {
        PrettyPrinter printer = new PrettyPrinter(60).add("Printing Villager Information").centre().hr().add("Sponge is going to print out information on all the merchant recipes based on mods");
        printer.add("Printing added recipes to add");
        printer.add();
        printer.add("Adding");
        for (int i = 0; i < temporary.size(); ++i) {
            MerchantRecipe recipe2 = (MerchantRecipe)temporary.get(i);
            printer.add((Object)" %d", i).add(" %s + %s = %s", recipe2.func_77394_a(), recipe2.func_77396_b(), recipe2.func_77397_d());
        }
        printer.add();
        printer.add("Now printing existing:").add();
        MerchantRecipeList existing = mixinEntityVillager.forgeBridge$getForgeTrades();
        printer.add("Existing");
        for (int i = 0; i < existing.size(); ++i) {
            MerchantRecipe recipe3 = (MerchantRecipe)existing.get(i);
            printer.add((Object)" %d", i).add(" %s + %s = %s", recipe3.func_77394_a(), recipe3.func_77396_b(), recipe3.func_77397_d());
        }
        List filtered = existing.stream().filter(recipe -> !temporary.contains(recipe)).collect(Collectors.toList());
        List forgeFiltered = temporary.stream().filter(recipe -> !filtered.contains(recipe)).collect(Collectors.toList());
        existing.addAll(filtered);
        existing.addAll(forgeFiltered);
        printer.add().add("Finalized List");
        for (int i = 0; i < existing.size(); ++i) {
            MerchantRecipe recipe4 = (MerchantRecipe)existing.get(i);
            printer.add((Object)" %d", i).add(" %s + %s = %s", recipe4.func_77394_a(), recipe4.func_77396_b(), recipe4.func_77397_d());
        }
        printer.log(SpongeImpl.getLogger(), Level.ERROR);
    }

    private static void printMismatch(int careerNumberId, Profession profession, List<Career> careers, VillagerProfessionBridge_Forge mixinProfession) {
        PrettyPrinter printer = new PrettyPrinter(60).add("Sponge Forge Career Mismatch!").centre().hr().addWrapped("Sponge is attemping to recover from a mismatch from a Forge mod provided VillagerCareer and Sponge's Career implementation.", new Object[0]).add().addWrapped("Due to the issue, Sponge is printing out all this information to assist sponge resolving the issue. Please open an issue on github for SpongeForge", new Object[0]).add();
        printer.add("%s : %s", "Forge Profession", mixinProfession.forgeBridge$getProfessionName());
        int i = 0;
        for (VillagerRegistry.VillagerCareer villagerCareer : mixinProfession.forgeBridge$getCareers()) {
            printer.add(" - %s %d : %s", "Career", i++, villagerCareer.getName());
        }
        printer.add();
        printer.add("%s : %s", "Sponge Profession", profession.getId());
        i = 0;
        for (Career spongeCareer : careers) {
            printer.add("  %s %d : %s", "Career", i++, spongeCareer.getId());
        }
        printer.add();
        printer.add("Villager career id attempted: " + careerNumberId);
        printer.log(SpongeImpl.getLogger(), Level.ERROR);
    }

    static {
        ALIASED_PROFESSION_BIMAP.put((Object)"minecraft:smith", (Object)ProfessionRegistryModule.BLACKSMITH);
        ALIASED_CAREER_MAP.put((Object)"leather", (Object)CareerRegistryModule.getInstance().LEATHERWORKER);
        ALIASED_CAREER_MAP.put((Object)"armor", (Object)CareerRegistryModule.getInstance().ARMORER);
        ALIASED_CAREER_MAP.put((Object)"tool", (Object)CareerRegistryModule.getInstance().TOOL_SMITH);
        ALIASED_CAREER_MAP.put((Object)"weapon", (Object)CareerRegistryModule.getInstance().WEAPON_SMITH);
    }
}

