/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.processor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.QualifiedNameable;

final class AnnotationWrapper<T extends Annotation> {
    private final T annotation;
    private final AnnotationMirror mirror;
    private final ImmutableMap<String, AnnotationValue> values;

    AnnotationWrapper(T annotation, AnnotationMirror mirror) {
        this.annotation = annotation;
        this.mirror = mirror;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        mirror.getElementValues().forEach((field, value) -> builder.put((Object)field.getSimpleName().toString(), value));
        this.values = builder.build();
    }

    T get() {
        return this.annotation;
    }

    AnnotationMirror getMirror() {
        return this.mirror;
    }

    ImmutableMap<String, AnnotationValue> getValues() {
        return this.values;
    }

    AnnotationValue getValue(String name) {
        AnnotationValue value = (AnnotationValue)this.values.get((Object)name);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Annotation value '%s' is not present in %s", (Object)name, (Object)this.mirror);
        return value;
    }

    static <T extends Annotation> AnnotationWrapper<T> of(AnnotatedConstruct element, Class<T> annotationClass) {
        Preconditions.checkNotNull((Object)element, (Object)"element");
        Preconditions.checkNotNull(annotationClass, (Object)"annotationClass");
        T annotation = element.getAnnotation(annotationClass);
        String name = annotationClass.getName();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!((QualifiedNameable)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(name)) continue;
            return new AnnotationWrapper<T>(annotation, annotationMirror);
        }
        throw new IllegalArgumentException("Annotation " + annotation + " not found in " + element);
    }
}

