/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.sync.packets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.client.gui.GuiWT;
import p455w0rd.ae2wtlib.api.container.ContainerWT;
import p455w0rd.ae2wtlib.api.networking.INetworkInfo;
import p455w0rd.ae2wtlib.api.networking.WTPacket;

public class PacketSyncInfinityEnergy
extends WTPacket {
    int infinityEnergy;
    int slot;
    boolean isBauble;
    UUID playerID;

    public PacketSyncInfinityEnergy(ByteBuf stream) {
        this.infinityEnergy = stream.readInt();
        this.slot = stream.readInt();
        this.isBauble = stream.readBoolean();
        this.playerID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)stream));
    }

    public PacketSyncInfinityEnergy(int energy, UUID playerID, boolean isBauble, int slot) {
        this.infinityEnergy = energy;
        this.slot = slot;
        this.isBauble = isBauble;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(this.infinityEnergy);
        data.writeInt(slot);
        data.writeBoolean(isBauble);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)playerID.toString());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WTPacket packet, EntityPlayer player) {
    }

    @Override
    public void clientPacketData(INetworkInfo network, WTPacket packet, EntityPlayer player) {
        EntityPlayer targetPlayer;
        if (this.slot >= 0 && player.func_130014_f_() != null && (targetPlayer = player.func_130014_f_().func_152378_a(this.playerID)) != null) {
            ItemStack wirelessTerm;
            ItemStack itemStack = wirelessTerm = this.isBauble ? WTApi.instance().getBaublesUtility().getWTBySlot(targetPlayer, this.slot, ICustomWirelessTerminalItem.class) : WTApi.instance().getWTBySlot(targetPlayer, this.slot);
            if (!wirelessTerm.func_190926_b()) {
                WTApi.instance().setInfinityEnergy(wirelessTerm, this.infinityEnergy);
                if (this.playerID.equals(player.func_110124_au()) && Minecraft.func_71410_x().field_71462_r instanceof GuiWT) {
                    GuiWT gui = (GuiWT)Minecraft.func_71410_x().field_71462_r;
                    ContainerWT container = (ContainerWT)gui.field_147002_h;
                    int containerSlot = container.getWTSlot();
                    boolean containerIsBauble = container.isWTBauble();
                    if (this.slot == containerSlot && this.isBauble == containerIsBauble) {
                        container.setWirelessTerminal(wirelessTerm);
                    }
                }
            }
        }
    }
}

