/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.entity;

import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableExperienceHolderData;
import org.spongepowered.api.data.manipulator.mutable.entity.ExperienceHolderData;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.entity.TargetEntityEvent;
import org.spongepowered.api.util.annotation.eventgen.AbsoluteSortPosition;
import org.spongepowered.api.util.annotation.eventgen.FactoryMethod;
import org.spongepowered.api.util.annotation.eventgen.PropertySettings;

public interface ChangeEntityExperienceEvent
extends TargetEntityEvent,
Cancellable {
    @PropertySettings(generateMethods=false, requiredParameter=false)
    @Deprecated
    default public int getOriginalExperience() {
        return (Integer)this.getOriginalData().totalExperience().get();
    }

    @AbsoluteSortPosition(value=1)
    public ImmutableExperienceHolderData getOriginalData();

    @PropertySettings(generateMethods=false, requiredParameter=false)
    @Deprecated
    default public int getExperience() {
        return (Integer)this.getFinalData().totalExperience().get();
    }

    @PropertySettings(generateMethods=false, requiredParameter=false)
    @Deprecated
    default public void setExperience(int experience) {
        this.getFinalData().set(Keys.TOTAL_EXPERIENCE, experience);
    }

    @AbsoluteSortPosition(value=2)
    public ExperienceHolderData getFinalData();

    @FactoryMethod
    @Deprecated
    public static ChangeEntityExperienceEvent createChangeEntityExperienceEvent(Cause cause, int originalExperience, int experience, Entity targetEntity) {
        ExperienceHolderData finalData = targetEntity.getOrCreate(ExperienceHolderData.class).orElseThrow(() -> new RuntimeException("Failed to get ExperienceHolderData from " + targetEntity));
        ImmutableExperienceHolderData originalData = (ImmutableExperienceHolderData)finalData.asImmutable();
        originalData = (ImmutableExperienceHolderData)originalData.with(Keys.TOTAL_EXPERIENCE, originalExperience).get();
        finalData.set(Keys.TOTAL_EXPERIENCE, experience);
        return SpongeEventFactory.createChangeEntityExperienceEvent(cause, originalData, finalData, targetEntity);
    }
}

